
Navigation = {
    init:function() {
        var self = this;
        //universal nav icon and submenu class assignment
        $("nav#uniNav ul:first").children("li").each(function(i){
            //if ie
            if (!jQuery.support.opacity) {
                $(this).addClass("nth-child"+(i+1))
                log("nth-child"+(i+1));
                if ( $(this).children("a").children("span").get(0) ){
                    $(this).children("a").children("span").each(function(n){
                        $(this).addClass("nth-child"+(n+1))
                    })
                }
            }
            //adding 'hasSub' to parent <li> of submenu
            if ( $(this).children("ul").get(0) ){
                $(this).addClass("hasSub");
            }
        })
        //  fade/load FORMS
        // redirect to open login form
        $("nav#uniNav ul li.login").click(function(event) {
            if($("article div#modal").length) return;
            Modal.join($("a",this).attr("href"),$("a",this).siblings("link[rel=redirect]").attr("href"));
            return false;
        });
			
        $("li.modal").click(function(event) {
            if($("article div#modal").length) return;
            Modal.join($(this).find("a").attr("href"),$(this).find("a").siblings("link[rel=redirect]").attr("href"));
            return false;
        });
			
        $("a.modal").click(function(event) {
            if($("article div#modal").length) return;
            Modal.join(this.href, $(this).siblings("link[rel=redirect]").attr("href"));
            return false;
        });
			
        Form.init();
        Modal.init(); // init related systems
    }
}

Modal = {
    onResize:null,
		
    redirect:null,
		
    xhr:undefined,
		
    init: function() {
    /* uncomment to make modal close when background is clicked
			$("#modal > .content > .background").click(function(event) {
				Modal.hide();
			});
			*/
			
    },
		
    join:	function(url,redirect) {
        Modal.redirect = redirect;
        Modal.show( function(e) {
            Modal.load(url + "?ajax")
        }); // show loader
    },
		
    show: function(onComplete) {
        //Page.o.mousewheel_disabled=true;
			
        $.scrollTo(0,300,{
            axis:'y'
        });
			
        if(Device.can_touch) $("li.video").children().addClass("hidden");
			
        $("#modal > .content > .form").css("width","auto");
        $("#modal").addClass("on").removeClass("light-box off").css({
            "width":"100%", 
            "height":($("article").height() + 38),
            "top":$("article").position().top
            }).fadeIn();
        $("#modal > .content > .background").animate({
            opacity:".90"
        },425,"easeInOutQuad", onComplete);
    },
		
    /**
		 * Task:  open the modal overlay as a lightbox covering entire screen and load a gallery template
		 */
    lightbox : function(onComplete, onResize, onClose) {
        //Page.o.mousewheel_disabled=true;
			
        $("#modal > .content > .form").css("width","auto");
        $("#modal").addClass("on light-box").removeClass("off").css({
            "min-height":$(document).height(), 
            "height":"100%", 
            "min-width":$(document).width(), 
            "width":"100%",
            "top":"0px"
        });
        $("#modal > .content > .background").animate({
            opacity:".90"
        },425,"easeInOutQuad",function() {
            // display the modal gallery template
            if(typeof(onComplete)=='function') onComplete();
        });		

        if(onResize && typeof(onResize)=='function') {
            Modal.onResize = onResize;
            $(window).bind("resize",Modal.onResize);
        }
			
        Modal.onClose = onClose;
    },
		
    hide: function() {
			
        if(Modal.onResize){
            $(window).unbind("resize",Modal.onResize);
            Modal.onResize = null;
        }
			
        if(Modal.onClose) {
            Modal.onClose();
            Modal.onClose = null;
        }
			
        //Page.o.mousewheel_disabled=false;
        if(Modal.xhr !== undefined) {
            Modal.xhr.abort();
        } 
        $("#modal > .content > .form").fadeOut("fast", function(event) {			
            $("#modal > .content > .background").animate({
                opacity:"0"
            },425,"easeInOutQuad", function() {
                $("#modal").removeClass("on").addClass("off").css({
                    "min-width":"", 
                    "min-height":"", 
                    "height":"auto", 
                    "width":"auto"
                }); // reset heights / widths
                $("#modal > .content > .form").removeClass("formSent");
                if(Device.can_touch) $("li.video").children().removeClass("hidden");
            //Page.reset();
            });
        });
    },
		
    load: function(url, onComplete) {
        if(Modal.xhr !== undefined) {
            Modal.xhr.abort();
        } 
        Modal.xhr = $.ajax({
            type: 'GET',
            url: url,
            success: function(data) {
                $("#modal > .content > .form").html(data).fadeIn("fast").width($("#modal > .content > .form > div").outerWidth());
                $("#modal > .content > .form .closeModal, .closeModalButton").live('click',function(e) {
                    Modal.hide();
                    return false;
                });
                //Page.reset();
                Form.init();
					
                //initLightbox(); //setup the light box in here		
                if(typeof(onComplete)=='function') onComplete($("#modal > .content > .form")); // pass in initLightbox (orwhatever) through a callback
            }
				
				
        });
    },
		
    insert:function(form) {
        $("#modal > .content > .form").removeChildren().append(form);
        Modal.show();
    }
}

Form = {
		
    error:function(data, target) {
        $("form .error").remove();
        var theURL = target.attr("action");
        var formID = target.attr("id");
			
        if ( data.indexOf("errorlist") != -1 ){ //error exists in the response
            var error = $(data).find(".errorlist");
            $(error).each(function(){					
                errorMSG = $(this).children("li").text();
                labelFor = $(this).siblings("label").attr("for");
				
                $("form#"+formID+" label[for|=" +labelFor+"]").parent().append('<span class="errorMessage">'+errorMSG+'</span>');
                $("form#"+formID+" label[for|=" +labelFor+"]").after('<span style="" class="icon error" title="'+errorMSG+'">'+errorMSG+'</span>');
					
            })
            return true;
        }
			
        return false;
    },
		
    init:function(){
			
        $(".stand-alone .closeModal").hide();
			
        $("input[type=checkbox], input[type=radio]").checkBox();
			
        if ( $("select").get(0) ){
            $("select:not(.hidden):not(.default)").each(function(){
                var select = $(this);
                if ($(this).is(":visible") && $(this).hasClass("noStyle")!=true ) { //if not hidden or already beautified :)
                    $(this).msDropDown();
                }
            })
        }
        if($("form#register").length && (Device.get_cookie("age_gate")=="failed")) {
            $("form#register").find("#id_submit").parent().empty().append('<p>We can not register you at this time, please refer to the riosiz <a href="/en/terms" title="Terms & Conditions">Terms & Conditions</a> for more information.</p>');
        }
			
        $("form.ajaxForm").submit(function(event){
            event.preventDefault();
            $("form .error").remove();
            $("form .errorMessage").remove();
				
            var form = $(this);
            theURL = $(this).attr("action") + "?ajax";
            formID=$(this).attr("id");
            formData = $(this).serialize();
				
            if($(this).attr("id")=='register') { // there should be a way to feed in an ONSUBMIT, ONERROR, custom function here
                if(!Form.check_age($(this).find("#id_birthday_month").val() + " " + $(this).find("#id_birthday_day").val() + ", " + $(this).find("#id_birthday_year").val())) {
                    $(this).find("#id_submit").parent().empty().append('<p>We can not register you at this time, please refer to the riosiz <a href="/en/terms" title="Terms & Conditions">Terms & Conditions</a> for more information.</p>');
                    return;
                }
            }
				
            var orgTxt = form.find(".submit").val();
            form.find(".submit").val("Sending...");
				
            $.ajax({
                url: theURL,
                type: 'POST',
                data: formData,
                //success: Form.error(data, form)
                success: function(data) {
						
                    form.find(".submit").val(orgTxt);
						
                    if ( data.indexOf("errorlist") != -1 ){ //error exists in the response
                        var error = $(data).find(".errorlist");
                        $(error).each(function(){
								
                            errorMSG = $(this).children("li").text();
                            labelFor = $(this).siblings("label").attr("for");
								
                            var input = $(this).siblings("input");
								
                            $("form#"+formID+" label[for|=" +labelFor+"]").parent().append('<span class="errorMessage">'+errorMSG+'</span>');
								
                            if(input.attr('type') == 'text' || input.attr('type') == 'password'){
                                $("form#"+formID+" label[for|=" +labelFor+"]").after('<span style="" class="icon error" title="'+errorMSG+'">'+errorMSG+'</span>');
                            }
								
                        })
							
                    } else if ( data.indexOf("message") != -1 ){						
                        switch(form.attr("id")) {
                            case 'retrieve-password':
                                form.find(".message-relay").html($(data).find(".message")).addClass("on");
                                form.find(".submit").val("Check Your Email").attr("disabled","disabled");
                                break
                            case 'change-password':	
                                form.find(".message-relay").html($(data).find(".message")).addClass("on");	
                                form.find(".submit").val("Password Changed").attr("disabled","disabled");
                                break;
                            default:
                                form.parents(".modal").parent().html(data);
                                return;
                        }
                    }else {
                        var redirect = (Modal.redirect != null) ? Modal.redirect : form.find("link[rel=redirect]").attr("href");
                        if(redirect) location.href=redirect;
                        else  location.reload(); // fail safe just reload the page or direct to new page
                    }
                }
            });
				
            return false;
        }).find("input[type=submit]").removeAttr("disabled");
    },
		
    check_age: function(dateStr) {
        if(Device.get_cookie("age_gate")=="failed") return;
        var rd = new Date(Date.parse(dateStr))
        var d = new Date();
        var age = d.getYear() - rd.getYear();
        if(d.getMonth() < rd.getMonth() || (d.getMonth() == rd.getMonth() && d.getDate() < rd.getDate()) ) age--;
        if(age < 13) {
            Device.set_cookie("age_gate","failed",3600);
            return;
        }
        return true;
    }
}


/**
	*	
	*/
var Device = {
		
    init: function() 
    {
        // Touch screen specific functionality + stlying for tablets and mobile
        if(this.can_touch) { 
            $(window).ready(this.remove_toolbar);
        }
			
        var targ = $("header nav > ul > li:nth-child(6) a"); // rainbow text on nav
        var text = targ.text().split("");
        targ.empty();
        for(var i = 0; i < text.length; i++) {
            $("<span>"+text[i]+"</span>").appendTo(targ);
        }
			
        $(".extend-grid").each(function(i,e) {	// 2. extend-grid-button component TODO Move to module level
            var classes = $(this).attr('class').split(' ')
            var numDots = Device.getClassValue(classes,"dots");
            numDots = (numDots) ? numDots : 10;
            for(var n=0; n < numDots; n++) {
                $(this).append("<div></div><div></div><div></div><div></div>");
            }
        });
    },
		
		
    is_ie:function() {
        return (!jQuery.support.opacity); // true ie, false not ie
    },
		
    /**
		* Determine if device is touch-capable
		*/
    can_touch: ('createTouch' in document),
		
    /**
		*	Scroll past location bar on iPhone 
		*/
    remove_toolbar: function() 
    {
        $.scrollTo('+=0px',100,{
            axis:'y'
        }); //scrolls 0px..but removes the toolbar on iphone
    },
		
		
    getClassValue: function (classes,string,isString){
        var temp = 0;
        var pos = string.length;
        for (var j=0;j<classes.length;j++) {
            if (classes[j].indexOf(string) == 0) {
                temp = classes[j].substring(pos);
                break;
            }
        }
        return (isString) ? temp : Math.max(0,temp);
    },
		
    querystring:function( name ) {
        name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
        var regexS = "[\\?&]"+name+"=([^&#]*)";
        var regex = new RegExp( regexS );
        var results = regex.exec( window.location.href );
        if( results == null ) return "";
        else return decodeURIComponent(results[1].replace(/\+/g, " "));
    },
		
    set_cookie: function setCookie(c_name,value,expireseconds) {
        var exdate=new Date();
        exdate.setSeconds(exdate.getSeconds()+expireseconds);
        document.cookie=c_name+ "=" +escape(value)+
        ((expireseconds==null) ? "" : ";expires="+exdate.toUTCString());
    },
		
    get_cookie: function getCookie(c_name)  {
        if (document.cookie.length>0) {
            c_start=document.cookie.indexOf(c_name + "=");
            if (c_start!=-1) {
                c_start=c_start + c_name.length+1;
                c_end=document.cookie.indexOf(";",c_start);
                if (c_end==-1) c_end=document.cookie.length;
                return unescape(document.cookie.substring(c_start,c_end));
					
            }
        }
        return "";
    }

}


/**
	 * Convert to classical inheritance
	 * Page needs to have an array of modules, it should control the module creation
	 */
Page = {
    o: {
        max				:false,
        page_data		:null,
        width			:Number(0),
        targ			:null,		// scrolling target
        sorting			:false		// for admin reordering
    },
		
    init:function(slug,page_data) {

        this.o.page_data = page_data;
        this.o.targ = $("section");
			
        // 1. clearing
        this.clear_unused_modules();
        // 2. resizing
			
        $("article").css("overflow-x","hidden")
			
        $("img.flow").bind("load",function(event) {
            Page.resize();
        }); // not sure if we need to resize after every image load
        $(document).ready(function(event) {
            Page.resize();
        });
        this._scroller();
        this.resize();
        // 3. page specific functions
        // TODO, if each page has its own template, reverse with Page.Home.init() which would call Page.init()
			
        switch(slug) {
            case 'home':
                Page.Index.init();
                break;
            case 'blog':
                Page.Blog.init();
                break;
            case 'search':
                Page.Search.init();
                break;
        }
			
        Page.onScrollComplete($("article"), $("section"), this.load_next_page); // onscrollcomplete load next page
			
        Page.reset();
        window.setTimeout(function() {
            Page.reset();
        }, 1000); //
        window.setInterval(function(){
            Page.reset();
        }, 4000); // failsafe reset for layout, consider adding to 1000 interval
			
        log('start admin')
        if($(".admin-panel").length && typeof(Admin) != 'undefined') {
            Admin.init();
        }
			
    /* setTimeout(function() { // for testing pagination of modules
				$("section").children().remove();
				Page.load_next_page() 
			}, 2000); */
			
    },
		
    /* load next page of modules */
    load_next_page:function(e) {
			
        var o = Page.o.page_data;
        o.current_page++;
        log(o.current_page + ' // ' + o.page_count);
        if(o.page_count >= o.current_page) { // next page exists, request it
            $.get(("?ajax&page="+(o.current_page)+"&per_page="+(o.per_page)), function(data) {
                //log(data);
                // how to fire the JS?
                $("section").append(data);
                //Page.scroller.setValue(0);
                Page.reset();// max width
                // re-add page modules
                riosiz.Page.add(); // add new modules
            });
        }else { // kill scroll pagination
            $("article").unbind("scroll");
        }
    },
		
    scroller:null,
    _scroller:function() {		
        var mask = $("article").scrollLeft(0);
        var content = $("section");
			
        log('new scroller')
        if(content.length) {
            this.scroller = new Dragdealer('site-slider', {
                speed:20,
                horizontal: true,
                vertical: false,
                xPrecision: content.outerWidth(),
                mask:mask,
                content:content,
                animationCallback: function(x, y) {
                    mask.scrollLeft(x*(content.outerWidth()-mask.outerWidth()));
                },
                animationComplete: function() {
						
                }
            });
            $("#scrollarea td.hidden").removeClass("hidden");
            if(Device.can_touch) {
                mask.jScrollTouch(false,this.scroller);
                mask.css("overflow","hidden");
            }
        }


        var resizeTimer = null;
        $(window).bind('resize', function() {
            if(Device.is_ie()) { // 
                $(".scrollbar-container").css("width","0px");
                $("#scrollarea").css("width","auto");
                $(".scrollbar-container").width(mask.width() - $("#scrollarea").width());
                $("#scrollarea").css("width","100%");
            }
            if(!content.length) return;
            $("#site-slider .handle").width( ((mask.width()/content.width()) * $("#site-slider").width()) -  12);
				
            if(Page.scroller) Page.scroller.documentResizeHandler();
				
            if(mask.width()/content.width()>=1) $("#scrollbar").addClass("hidden");
            else $("#scrollbar").removeClass("hidden");
        });
    },
		
    /* onScrollComplete lazy load pagination */
    onScrollComplete:function(mask, content, callBack) {
        var scrollCompleteTimer = null;
        mask.bind("scroll", function(e) {
            if (scrollCompleteTimer) clearTimeout(scrollCompleteTimer);
            scrollCompleteTimer = setTimeout(function() {
                if(mask.scrollLeft() + mask.width() >= content.width() && callBack && typeof(callBack) == "function") callBack(e); // if reached end of scrolled content
            }, 500);
        });
    },
		
    clear_unused_modules:function() {
        $(".module").each(function(i) {
            if($(".content",$(this)).length == 0) $(this).remove();
        });
    },
		
    reset:function() {
        this._setWidth(999999);// max width
        this.resize(false);
        this.attach_scroll_wheel();
    },
		
    attach_scroll_wheel:function() {
        if(!Device.can_touch) {
				
            if($(document).width() <= $(window).width() && $(document).height() <= $(window).height() && !this.o.mousewheel_disabled) {
                var self = this;
                if(!this.o.mousewheel_attached) {
                    this.o.mousewheel_attached = true;
                    $(document).mousewheel(function(event, delta, deltaX, deltaY) {
                        Page.scroller.scrollToDelta(Math.round(delta*500),0);
                    });
                }
            }else {
                this.o.mousewheel_attached = false;
                $(document).unmousewheel();
            }
        }
    },
		
    resize: function(max) {
			
        if(!this.o.targ) this.init();
        if(max != undefined)this.o.max = max; //Bool to lock to max width found (for animating widths)
        this._setWidth(this._getWidth());
        $(window).trigger("resize");
    },
			
    _getWidth:function() {
        var width = 30;
        $(".module").each(function(i,e) { // get total width in pixels of module area
            width += $(this).outerWidth(true);
        });
        this.o.width = width;
        return width;
    },
		
    _setWidth:function(w) {
        if(this.o.max && w < parseInt(this.o.targ.css('width'))) return; // if max, dont resize down
        this.o.targ.css('width',w); 	//set section width
    }
			
}


Page.Index = {
    o : {},
		
    init:function() {
        // create a button for each module
        var resizeTimer = null;
        $(window).bind('resize', function() {
            if (resizeTimer) clearTimeout(resizeTimer);
            resizeTimer = setTimeout(function() {
                if(!Page.o.sorting && (!Page.Index.o.aw || Page.Index.o.aw != $("article").width() || Page.Index.o.sw != $("section").width())) {
                    Page.Index.module_buttons();
                    Page.Index.o.aw = $("article").width();
                    Page.Index.o.sw = $("section").width();
                }
            }, 100);
        });
        Page.scroller.disableContainerClick();
    },
		
    module_buttons:function() {
        var container = $("#scrollarea #scrollbar #site-slider");
        $(".module-button",container).remove(); // clear
        $("article section .module").each(function(index,value) {
            var mod = $(this);
            $('<div title="'+mod.find("a.module-title").attr("title")+'"/>').html('<div class="arrow"></div><div class="arrow right"></div>')
            .addClass("module-button")
            .prependTo(container)
            .css("left",(10 + ( (  (mod.position().left + ( mod.outerWidth()/2)) / mod.parent().outerWidth()) * container.width())      ) )
            .click(function(e) {
                Page.scroller.setValue((mod.position().left + 30)/($("section").width()),0,false);
                return false;
            })
            .mouseover(function(e) {
                $(this).find(".arrow").css("border-color","transparent #fff");
            })
            .mouseout(function(e) {
                $(this).find(".arrow").css("border-color","transparent " + Device.getClassValue(mod.attr('class').split(' '),"color",true));
            })
            .find(".arrow").css("border-color","transparent " + Device.getClassValue(mod.attr('class').split(' '),"color",true))
        });
    }
		
}
