$(document).ready(function() {

	// ===========================
	// = Internet Explorer Fixes =
	// ===========================
	iefix_init();
	
	// ====================
	// = Global Functions =
	// ====================
	global_init();

	// ===========================
	// = Page specific functions =
	// ===========================
	
method_init();
	

});

var featured_item;
var image;
var heading;
var description;
var featured_link;

//var featured_items;
//var images;
//var headings
//var descriptions;


// =====================
// = Featured projects =
// =====================
function work_init () {
	var current_item = 0;
	var old_item = featured_data.length -1;
	var delay = 6000;
	
	//Preload images
	preload_featured_images();
	
	featured_item = $('#content').find('.featured');
	image = featured_item.find('img');
	heading = featured_item.find('h2.off-right a');
	featured_link = featured_item.find('h1.replace a');
//	heading = featured_item.find('h2.off-right a')
	description = featured_item.find('p');
	var mask_height = 1124;
	var maskWrapper = $('<div/>').css({
		position: 'absolute',
		overflow: 'hidden',
		height: 334,
		width: featured_item.width(),
		top: 0
	});
	var mask = $('<div/>').css({
		position: 'absolute',
		backgroundImage: 'url(/images/assets/mask3.png)',
		backgroundRepeat: 'no-repeat',
		backgroundPosition: 'center center',
		height : mask_height,
		width : featured_item.width(),
		top: -1 * mask_height,
		left: 0
	})
	
	maskWrapper.append(mask);
	featured_item.append(maskWrapper);
	
	
	
	

	if(featured_data.length > 1){
		//Start the loop
		setTimeout(fade_loop, delay)
	}
	
	
	function fade_loop(){
		//Set the correct current and last item
		if(current_item == (featured_data.length -1)){
			current_item = 0;
			old_item = featured_data.length -1
		}else{
			current_item++;
			old_item = current_item - 1;
		}
		
		mask.animate({top: mask_height}, 1500, function(){
			mask.css('top', -1*mask_height)
		})
		
		setTimeout(function(){
			image.attr('src', featured_data[current_item].image);
			heading.text(featured_data[current_item].title).attr('href', featured_data[current_item].link);
			featured_link.attr('href', featured_data[current_item].link);
			var newDescription = $(featured_data[current_item].description);
			description.replaceWith(newDescription);
			
			description = newDescription;
		}, 550)
		
		
		
		setTimeout(fade_loop, delay);
	
		
	}
	
}





// =======================
// = Circles on Homepage =
// =======================

var bottle ;
var bottle_anchors;
var bottle_sprite;
var sprite_holder;


function home_init () {
	var buttonwrapper = $('#content-left')
	var buttons = buttonwrapper.find('a');
	var lists = $('#content-right').find('ul');
	var paragraph = $("#how-description");
	var methodtext = "How do we do it?";
	var methodhovertext = "Learn about our method";
	
	bottle = $("#bottle");
	bottle_anchors = bottle.find("a");
	bottle_sprite  = bottle.find(".sprite");
	sprite_holder = bottle.find('#sprite_holder');
	
	buttons.hover(function(){
		lists.css('display', 'none');
		$("#content-left h1.replace").text(methodhovertext).css("color", "#a7d019");
		$($(this).attr('href')).fadeIn(200);
	}, function(){
		$($(this).attr('href')).fadeOut(300);
	
	})
	
	//When the circles are clicked, take them to the method page
	buttons.click(function(){
		//The method_page variable is initialized in the page header by EE
		window.location = method_page;
	})
	
	buttonwrapper.hover(function(){
		paragraph.fadeOut(200);
	}, function(){
		$("#content-left h1.replace").text(methodtext).css("color", "#fff");;
		paragraph.fadeIn(300);
	})

// ================================
// = Logos hover text replacement =
// ================================
	
	var placeholdertext = "Who have we helped?";
	var hovertext = "View our work";
	
	$("a.slider").hover(function(){
		// on mouseover
		$("a.slider h1.replace").text(hovertext);
		
	}, function() {
		// on mouseout
		$("a.slider h1.replace").text(placeholdertext);
		
	});
	
	
	
	//Bottle
	bottle_anchors.each(function(i){
		
		bottle_anchors.eq(i).hover(function(){
			
			fadeInSprite(this.className);
		}, function(){
			fadeOutSprite(this.className);
		})
	
	})
	
	bottle.bind('mouseout', function(e){

			if(e.srcElement.nodeName == "A"){
				fadeOutSprite(e.srcElement.className);
			}
	});
}

var bottle_animating = false;
var active_sprite;
var active_sprite_name;

function fadeInSprite(className){
		
	active_sprite_name = className;
	
	if(!bottle_animating){
		bottle_animating = true;
		
		sprite_holder.empty();
		
		var active_sprite = bottle_sprite
							.clone()
							.hide()
							.addClass(className)
							.appendTo(sprite_holder)
							.fadeIn(300);
		bottle_sprite.fadeOut(300);
		
		sprite_holder.add(active_sprite);
	}	
}

function fadeOutSprite(className){
	
	
	
	sprite_holder.children().fadeOut(150, function(){
		sprite_holder.empty();
		
		bottle_animating = false;
	
		if(active_sprite_name != className){
			fadeInSprite(active_sprite_name);
		}
		
	});
	
	bottle_sprite.fadeIn(150);
	
}


// ===========================
// = Global JS Functionality =
// ===========================

function global_init () {
	
	
	
	    
	
}




// ================
// = Contact Page =
// ================
function contact_init () {
	
	// ==============
	// = Google Map =
	// ==============
	
	//Map
	var centerPoint = new google.maps.LatLng(51.385234,-2.361277);
	var gmap = new google.maps.Map(document.getElementById('gmap'), {
		zoom: 16,
		mapTypeId: google.maps.MapTypeId.ROADMAP,
		center: centerPoint
	});
	
	//Marker
	var marker = new google.maps.Marker({
		map: gmap,
		position: centerPoint,
		title: "moresoda design ltd.",
		icon: '/images/assets/gmap_icon.png'
	})
}







// ===============
// = Method Page =
// ===============
function method_init () {
	
	// ----- METHOD IMAGE ROTATION -----

	$('.cogs .image').addClass('rotate');
	
	$('#logo').click(function(e){
		if(e.metaKey){
			$('.cogs .image').toggleClass('rotate').toggleClass('rewind');
			return false;
		}
		
	});


	// ----- METHOD UL TOGGLE -----

	$('.cogs .three ul.white').siblings('ul').addClass('hide'); // hides all ul's except the first one
	
	$('.cogs .replace a').hover(function() {
		var target = $(this).attr('rel');
	
	
		$('.cogs .three ul.' + target).siblings('ul').addClass('hide'); // add's hide to all other ul's
		$('.cogs .three ul.' + target).removeClass('hide'); // shows the correct ul
		return false;
	}, function() {
		// on mouseout
		$('.cogs .three ul.white').siblings('ul').addClass('hide');
		$('.cogs .three ul.white').removeClass('hide');
	});
}




// ============
// = IE Fixes =
// ============
function iefix_init () {
	// IE Fixes
		$('#nav li:last-child a').addClass('last')

		$('.projects .work-list li:nth-child(4n)').addClass('last')

		$('.services-upper .column:nth-child(4)').addClass('last')
		$('.services-upper .column:first-child').addClass('first')	
		$('.services-lower .column:last-child').addClass('last')	

		$('.team li:last-child').addClass('last')

		$('#footer .copy li:first-child').addClass('first')
		$('#footer .column:last-child').addClass('last')
		$('#footer .column .posts li:last-child').addClass('last')
		
	     if (!Modernizr.borderradius) {

	         $.getScript("js/jquery.corner.js", function () {
				$('#nav li a').corner('10px');
				$('a.button').corner('10px');
	         });

	    }
		
		
}

//Preloads the images in the featured item array
function preload_featured_images() {
	for(var i = 0; i < featured_data.length; i++){
		var a = new Image(1,1);
		a.src = featured_data[i].image;
	}
}