// tabledeleterow.js version 1.2 2006-02-21
// mredkj.com

// CONFIG notes. Below are some comments that point to where this script can be customized.
// Note: Make sure to include a <tbody></tbody> in your table's HTML

var INPUT_NAME_PREFIX = 'vCity[]'; // this is being set via script
var INPUT_NAME_PREFIX_ZIP = 'vZip[]';
var RADIO_NAME = 'totallyrad'; // this is being set via script
var TABLE_NAME = 'tblSample'; // this should be named in the HTML
var ROW_BASE = 1; // first number (for display)
var hasLoaded = false;



function fillInRows()
{
	hasLoaded = true;
	insertRowToTable();
}

// CONFIG:
// myRowObject is an object for storing information about the table rows
function myRowObject(one, two, three, four)
{
	this.one = one; // text object
	this.two = two; // input text object
}

/*
 * insertRowToTable
 * Insert and reorder
 */
function insertRowToTable()
{
	var totRows,totRowsArr,num;
	totRowsArr = document.getElementById("vOptionsAdded").value.split(",");
	totRows = totRowsArr.length;
	if (hasLoaded) {
		for(ii=1;ii<=totRows;ii++)
		{
			num = ii;
			var tbl = document.getElementById(TABLE_NAME);
			var nextRow = tbl.tBodies[0].rows.length;
			var iteration = nextRow + ROW_BASE;
			if (num == null) { 
				num = nextRow;
			} else {
				iteration = num + ROW_BASE;
			}
			
			// add the row
			var row = tbl.tBodies[0].insertRow(0);
			
			// CONFIG: requires classes named classy0 and classy1
			row.className = 'classy' + (iteration % 2);
		
			// CONFIG: This whole section can be configured
					
			// cell 1 - input text
			var cell1 = row.insertCell(0);
			var txtInp = document.createElement('input');
			txtInp.setAttribute('type', 'text');
			txtInp.setAttribute('name', INPUT_NAME_PREFIX);
			txtInp.setAttribute('id', 'vCity' + ii);
			txtInp.setAttribute('size', '5');
			txtInp.setAttribute('readOnly', 'true');
			txtInp.setAttribute('value', Trim(totRowsArr[ii-1])); // iteration included for debug purposes
			cell1.appendChild(txtInp);

			var cell1 = row.insertCell(1);
			var txtInp = document.createElement('input');
			txtInp.setAttribute('type', 'text');
			txtInp.setAttribute('name', INPUT_NAME_PREFIX_ZIP);
			txtInp.setAttribute('id', 'vZip' + ii);
			txtInp.setAttribute('size', '5');
			txtInp.setAttribute('readOnly', 'true');
			txtInp.setAttribute('value', Trim(totRowsArr[ii-1])); // iteration included for debug purposes
			cell1.appendChild(txtInp);

			
			// cell 2 - input button
			var cell2 = row.insertCell(2);
			var btnEl = document.createElement('input');
			btnEl.setAttribute('type', 'button');
			btnEl.setAttribute('value', 'Delete');
			btnEl.onclick = function () {deleteCurrentRow(this)};
			cell2.appendChild(btnEl);
					
			// Pass in the elements you want to reference later
			// Store the myRow object in each row
			row.myRow = new myRowObject(txtInp,btnEl);
			reorderRows(tbl, num);
		}
	}
}

/*
 * addRowToTable
 * Inserts at row 'num', or appends to the end if no arguments are passed in. Don't pass in empty strings.
 */
function addRowToTable(num)
{
	if(!checkValidNull(document.getElementById("vCity"),"Please Select City for new attribute option "))
		return false;	
	if(!checkValidNull(document.getElementById("vZip"),"Please enter Zip Code for new attribute option"))
		return false;	

	var tbl = document.getElementById(TABLE_NAME);
	var nextRow = tbl.tBodies[0].rows.length;

	var iteration = nextRow + ROW_BASE;	
	if (num == null) { 
		num = nextRow;
	} else {
		iteration = num + ROW_BASE;
	}

	/*This portion is used for duplication check*/
	if(iteration>1)
	{
		for(k=iteration-1;k>0;k--)
		{
			if(document.getElementById('vCity'+k).value == document.getElementById("vCity").value)
			{	
				alert("City already exists");
				return false;
			}
			if(document.getElementById('vZip'+k).value == document.getElementById("vZip").value)
			{	
				alert("Zip Code already exists");
				return false;
			}
		}
	}
	/* End Portion */

	// add the row
	var row = tbl.tBodies[0].insertRow(0);
	//alert(row);return false;
	// CONFIG: requires classes named classy0 and classy1
	row.className = 'classy' + (iteration % 2);

	// CONFIG: This whole section can be configured
			
	// cell 1 - input text
	var cell1 = row.insertCell(0);
	var txtInp = document.createElement('input');
	txtInp.setAttribute('type', 'text');
	txtInp.setAttribute('name', INPUT_NAME_PREFIX);
	txtInp.setAttribute('id', 'vCity' + iteration);
	txtInp.setAttribute('size', '5');
	txtInp.setAttribute('readOnly', 'true');
	txtInp.setAttribute('value',document.getElementById("vCity").value); // iteration included for debug purposes
	cell1.appendChild(txtInp);

	var cell1 = row.insertCell(1);
	var txtInp = document.createElement('input');
	txtInp.setAttribute('type', 'text');
	txtInp.setAttribute('name', INPUT_NAME_PREFIX_ZIP);
	txtInp.setAttribute('id', 'vZip' + iteration);
	txtInp.setAttribute('size', '5');
	txtInp.setAttribute('readOnly', 'true');
	txtInp.setAttribute('value',document.getElementById("vCity").value); // iteration included for debug purposes
	cell1.appendChild(txtInp);
	
	// cell 2 - input button
	var cell2 = row.insertCell(2);
	var btnEl = document.createElement('input');
	btnEl.setAttribute('type', 'button');
	btnEl.setAttribute('value', 'Delete');
	btnEl.onclick = function () {deleteCurrentRow(this)};
	cell2.appendChild(btnEl);
			
	// Pass in the elements you want to reference later
	// Store the myRow object in each row
	row.myRow = new myRowObject(txtInp,btnEl);
	reorderRows(tbl, num);
	document.getElementById("vCity").focus();

	
}

// CONFIG: this entire function is affected by myRowObject settings
// If there isn't a checkbox in your row, then this function can't be used.
function deleteChecked()
{
	
		var checkedObjArray = new Array();
		var cCount = 0;
	
		var tbl = document.getElementById(TABLE_NAME);
		for (var i=0; i<tbl.tBodies[0].rows.length; i++) {
			if (tbl.tBodies[0].rows[i].myRow && tbl.tBodies[0].rows[i].myRow.three.getAttribute('type') == 'checkbox' && tbl.tBodies[0].rows[i].myRow.three.checked) {
				checkedObjArray[cCount] = tbl.tBodies[0].rows[i];
				cCount++;
			}
		}
		if (checkedObjArray.length > 0) {
			var rIndex = checkedObjArray[0].sectionRowIndex;
			deleteRows(checkedObjArray);
			reorderRows(tbl, rIndex);
		}

}

// If there isn't an element with an onclick event in your row, then this function can't be used.
function deleteCurrentRow(obj)
{
	var delRow = obj.parentNode.parentNode;
	var tbl = delRow.parentNode.parentNode;
	var rIndex = delRow.sectionRowIndex;
	var rowArray = new Array(delRow);
	//alert(rowArray.length);
	deleteRows(rowArray);
	reorderRows(tbl, rIndex);	
}

function reorderRows(tbl, startingIndex)
{
		if (tbl.tBodies[0].rows[startingIndex]) {
			var count = startingIndex + ROW_BASE;
			for (var i=startingIndex; i<tbl.tBodies[0].rows.length; i++) {
				
				// CONFIG: next line is affected by myRowObject settings
				//alert(1);
				tbl.tBodies[0].rows[i].myRow.one.name = INPUT_NAME_PREFIX; // input text
				
				// CONFIG: next line is affected by myRowObject settings

				var tempVal = tbl.tBodies[0].rows[i].myRow.two.value.split(' '); // for debug purposes
				
				tbl.tBodies[0].rows[i].myRow.two.value = tempVal[0]; // for debug purposes
				count++;
				//j=i;
			//alert(document.getElementById('vAttributeName'+i).value);	
			}
			/*alert(tbl.tBodies[0].rows[0].value);
			for(var j =0 ;j<tbl.tBodies[0].rows.length;j++)
			{
				var j=0;
				alert(document.getElementById('vAttributeName' + j).value);
			}
			*/
		}
	
}

function deleteRows(rowObjArray)
{
	
	for (var i=0; i<rowObjArray.length; i++) {
		var rIndex = rowObjArray[i].sectionRowIndex;
		rowObjArray[i].parentNode.deleteRow(rIndex);
	}
	
}

function openInNewWindow(frm)
{
	// open a blank window
	var aWindow = window.open('', 'TableAddRow2NewWindow',
	'scrollbars=yes,menubar=yes,resizable=yes,toolbar=no,width=400,height=400');
	
	// set the target to the blank window
	frm.target = 'TableAddRow2NewWindow';
	
	// submit
	frm.submit();
}