DROP TABLE IF EXISTS `tm_admin`;
CREATE TABLE IF NOT EXISTS `tm_admin` (
  `iAdminId` int(12) NOT NULL auto_increment,
  `vFirstName` varchar(150) NOT NULL,
  `vLastName` varchar(150) NOT NULL,
  `vEmail` varchar(255) NOT NULL,
  `vUserName` varchar(100) NOT NULL,
  `vPassword` varchar(100) NOT NULL,
  `vFromIP` varchar(20) NOT NULL default '',
  `dLastLogin` datetime NOT NULL default '0000-00-00 00:00:00',
  `dDate` date default NULL,
  `eStatus` enum('Active','Inactive') NOT NULL default 'Active',
  PRIMARY KEY  (`iAdminId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tm_dynamic_label`;
CREATE TABLE IF NOT EXISTS `tm_dynamic_label` (
  `iDLabelId` int(10) NOT NULL auto_increment,
  `vLabelName` varchar(100) NOT NULL,
  `vLinkName` varchar(100) NOT NULL,
  `vLink` varchar(512) NOT NULL,
  `vLinkTitle` varchar(500) NOT NULL,
  `eTarget` enum('Self','New') NOT NULL,
  `dDate` datetime NOT NULL,
  `eStatus` enum('Active','Inactive') NOT NULL default 'Active',
  PRIMARY KEY  (`iDLabelId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tm_page_manager`;
CREATE TABLE IF NOT EXISTS `tm_page_manager` (
  `iPageMId` int(12) NOT NULL auto_increment,
  `tHeading` text NOT NULL,
  `lContent` longtext NOT NULL,
  `iViewed` smallint(10) NOT NULL,
  `dDate` datetime NOT NULL,
  `dModifiedDate` datetime NOT NULL,
  `vPageName` varchar(500) NOT NULL,
  `vTitle` varchar(500) NOT NULL,
  `vKeyword` varchar(600) NOT NULL,
  `vDescription` varchar(600) NOT NULL,
  `eStatus` enum('Active','Inactive') NOT NULL,
  PRIMARY KEY  (`iPageMId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



DROP TABLE IF EXISTS `tm_page_search`;
CREATE TABLE IF NOT EXISTS `tm_page_search` (
  `iPSearchId` int(12) NOT NULL auto_increment,
  `vSearch` varchar(255) NOT NULL,
  `iTotalSearchResult` int(12) NOT NULL,
  PRIMARY KEY  (`iPSearchId`),
  KEY `iTotalSearchResult` (`iTotalSearchResult`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `tm_page_settings`;
CREATE TABLE IF NOT EXISTS `tm_page_settings` (
  `iPageId` int(10) NOT NULL auto_increment,
  `vDescription` varchar(255) NOT NULL default '',
  `vFileName` varchar(255) NOT NULL default '',
  `vFilePath` varchar(255) NOT NULL default '',
  `tPageContent` text NOT NULL,
  `vHtaccessName` varchar(50) NOT NULL,
  PRIMARY KEY  (`iPageId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

DROP TABLE IF EXISTS `tm_setting`;
CREATE TABLE IF NOT EXISTS `tm_setting` (
  `vName` varchar(255) NOT NULL default '',
  `vDesc` varchar(255) NOT NULL default '',
  `vValue` text NOT NULL,
  `iOrderBy` tinyint(1) NOT NULL default '0',
  `eConfigType` enum('General','Appearance','Meta Tag Informatioin') NOT NULL default 'General',
  `eDisplayType` enum('text','selectbox','textarea','checkbox','file','Image') NOT NULL default 'text',
  `eSource` enum('List','Query') default NULL,
  `vSourceValue` varchar(255) NOT NULL default '',
  `eSelectType` enum('Single','Multiple') NOT NULL default 'Single',
  `vDefValue` varchar(255) NOT NULL default '',
  `eStatus` enum('Active','Inactive') NOT NULL default 'Active',
  PRIMARY KEY  (`vName`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

# data

INSERT INTO `tm_setting` (`vName`, `vDesc`, `vValue`, `iOrderBy`, `eConfigType`, `eDisplayType`, `eSource`, `vSourceValue`, `eSelectType`, `vDefValue`, `eStatus`) VALUES
('ADMIN_PAGING_BOTTOM', 'Show Paging at Bottom in Admin', 'Y', 10, 'Appearance', 'checkbox', NULL, '', 'Single', 'Y', 'Active'),
('ADMIN_PAGING_TOP', 'Show Paging at Top in Admin', 'Y', 9, 'Appearance', 'checkbox', NULL, '', 'Single', 'Y', 'Active'),
('ADMIN_TITLE', 'Admin Site Title', '::. White Whitehat Copycat System 2 .:: [Admin Control Panel]', 1, 'Appearance', 'text', NULL, '', 'Single', '', 'Active'),
('ALPHA_SEARCH_BOTTOM', 'Show Alphabet Search at Bottom', 'Y', 8, 'Appearance', 'checkbox', NULL, '', 'Single', 'Y', 'Active'),
('ALPHA_SEARCH_TOP', 'Show Alphabet Search at Top', 'Y', 7, 'Appearance', 'checkbox', NULL, '', 'Single', 'Y', 'Active'),
('COPY_RIGHT_TEXT', 'Site Footer Text', '', 0, 'General', 'text', NULL, '', 'Single', '', 'Active'),
('CPANEL_TITLE', 'Site Control Panel Title', '::.  White Whitehat Copycat System 2   .:: ', 2, 'Appearance', 'text', NULL, '', 'Single', '', 'Active'),
('SITE_OWNER_ADDRESS', 'Site Owner Office/Home Address', '', 6, 'General', 'textarea', NULL, '', 'Single', '', 'Active'),
('SITE_OWNER_EMAIL', 'Site Support Email', '', 7, 'General', 'text', NULL, '', 'Single', '', 'Active'),
('FRONT_SITE_TITLE', 'Show Frontend Title', 'White Whitehat Copycat System 2', 1, 'Appearance', 'text', NULL, '', 'Single', '', 'Active'),
('PAGELIMIT', 'Page Limit (Admin Side)', '10', 6, 'Appearance', 'text', NULL, '', 'Single', '10', 'Active'),
('RECLIMIT', 'No Of Records Per Page (Admin Side)', '100', 5, 'Appearance', 'text', NULL, '', 'Single', '10', 'Active'),
('USER_PAGE_LIMIT', 'Front Page Limit', '10', 4, 'Appearance', 'text', NULL, '', 'Single', '7', 'Active'),
('USER_REC_LIMIT', 'No Of Records Per Page Front Side', '20', 3, 'Appearance', 'text', NULL, '', 'Single', '7', 'Active'),
('META_DESCRIPTION', 'Meta Description', 'White Whitehat Copycat System 2', 3, 'Meta Tag Informatioin', 'textarea', NULL, '', 'Single', '', 'Active'),
('META_KEYWORD', 'Meta Keyword', 'White Whitehat Copycat System 2', 2, 'Meta Tag Informatioin', 'textarea', NULL, '', 'Single', '', 'Active'),
('META_OTHER', 'Other SEO Related META TAGS', '<meta name="robots" content="index,follow">\r\n<META NAME="GOOGLEBOT" CONTENT="INDEX, FOLLOW">\r\n<meta name="revisit-after" content="2 days">\r\n<meta name="reply-to" content="">\r\n<meta name="document-classification" content="Internet">\r\n<meta name="document-type" content="Public">\r\n<meta name="document-rating" content="Safe for Kids">\r\n<meta name="document-distribution" content="Global">', 4, 'Meta Tag Informatioin', 'textarea', NULL, '', 'Single', '', 'Active'),
('GOOGLE_TRACKING_CODE', 'Google Analystic Tracking Code', '', 0, 'General', 'textarea', NULL, '', 'Single', '', 'Active'),
('GOOGLE_SITEMAP', 'Google Sitemap', '', 0, 'General', 'file', NULL, '', 'Single', '', 'Active'),
('SITE_LOGO', 'Website Logo', '', 8, 'General', 'Image', NULL, 'jpg,jpeg,gif,png', 'Single', '', 'Active'),
('FRONT_CONTACT_US_FORM_TITLE', 'Contact Us Form Title', 'Contact White Whitehat Copycat System 2', 2, 'General', 'text', NULL, '', 'Single', '', 'Active'),
('FRONT_HOME_PAGE_MIDDLE_IMAGE', 'Home Page Middle Image', '', 1, 'General', 'Image', NULL, 'jpg,jpeg,gif,png', 'Single', '', 'Active'),
('THEME', 'Theme', 'default', 1, 'General', 'text', NULL, '', 'Single', '', 'Inactive');

INSERT INTO `tm_page_settings` (`iPageId`, `vDescription`, `vFileName`, `vFilePath`, `tPageContent`, `vHtaccessName`) VALUES
(1, 'About Us', 'aboutus.php', '', '<p><strong>Lorem Ipsum</strong> is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br />\r\n<br />\r\nContrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of &quot;de Finibus Bonorum et Malorum&quot; (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, &quot;Lorem ipsum dolor sit amet..&quot;, comes from a line in section 1.10.32.</p>', ''),
(2, 'Home Page Middle Text', 'index.php', '', '<p><strong>Lorem Ipsum</strong> is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br />\r\n<br />\r\nContrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of &quot;de Finibus Bonorum et Malorum&quot; (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, &quot;Lorem ipsum dolor sit amet..&quot;, comes from a line in section 1.10.32.</p>', ''),
(3, 'Home Page Top Text', 'index.php', '', '<table cellspacing=\\"0\\" cellpadding=\\"0\\" width=\\"100%\\" border=\\"0\\">\r\n    <tbody>\r\n        <tr>\r\n            <td class=\\"welcome-text\\" valign=\\"top\\" align=\\"left\\">Welcome to Whitehat Copycat System 2!</td>\r\n        </tr>\r\n        <tr>\r\n            <td class=\\"padi-uniblue-text\\" valign=\\"top\\" align=\\"left\\">&nbsp;Thank you for installing Whitehat Copycat System 2!</td>\r\n        </tr>\r\n        <tr>\r\n            <td valign=\\"top\\" align=\\"left\\"><a title=\\"More\r\n            Information\\" href=\\"aboutus.html\\">More Information</a></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', ''),
(4, 'Privacy Policy', 'privacy_policy.php', '', '<p><strong>Lorem Ipsum</strong> is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br />\r\n<br />\r\nContrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source. Lorem Ipsum comes from sections 1.10.32 and 1.10.33 of &quot;de Finibus Bonorum et Malorum&quot; (The Extremes of Good and Evil) by Cicero, written in 45 BC. This book is a treatise on the theory of ethics, very popular during the Renaissance. The first line of Lorem Ipsum, &quot;Lorem ipsum dolor sit amet..&quot;, comes from a line in section 1.10.32.</p>', ''),
(5, 'Contact Us Text', 'contactus.php', '', 'Whitehat Copycat System 2<br />\r\nStreet Address,<br />\r\nCity,<br />\r\nState&nbsp;- Pin&nbsp;<br />\r\nCountry<br />\r\n<br />\r\n<strong>Phone :</strong>', '');

INSERT INTO `tm_admin` (`iAdminId`, `vFirstName`, `vLastName`, `vEmail`, `vUserName`, `vPassword`, `vFromIP`, `dLastLogin`, `dDate`, `eStatus`) VALUES
(1, 'First Name', 'Last Name', '', 'adm1n!34', 'Qadmin!34', '', '0000-00-00 00:00:00', '', 'Active'),
(2, 'First Name', 'Last Name', '', 'adm1n345', 'admin123', '', '0000-00-00 00:00:00', '', 'Active');