<?php

	$sites['Social bookmarking']['Clipmarks']['fields']=array(
					'user'=>'',				// Username				[str]
					'password'=>'',			// Password				[str]
					'post_random'=>'',		// Post random links	[0|1]
					'post_frequency'=>'',	// Post every			[int]
					'post_chance'=>'',		// % chance of posting	[1-100]
					'post_all'=>'',			// Post every new post	[1|0]
					'post_start'=>'',		// Start date			[timestamp]
					'show_on_widget'=>'',	// Display on sidebar	[1|0]
				);
	$sites['Social bookmarking']['Clipmarks']['spin']=array('title','clip','comment','tags');
	$sites['Social bookmarking']['Clipmarks']['site']='clipmarks.com';

	function t09_sb_clipmarks($id,$acc,$sb,$fuzz=false){
		$u=$acc['user'];
		$p=$acc['password'];
		$u=urlencode($u);
		$p=urlencode($p);

		if($fuzz&&count($fuzz)){
			$isfuzz=true;
			$title=$comment=$fuzz['title'];
			$tags=str_replace(' ',',',$title);
			$content=$fuzz['text'];
			$perma=$fuzz['url'];
			if(method_exists($sb,'shorten'))$perma=$sb->shorten($perma);
			$url=$sb->profile_url($acc);
			$sb->sblog($url['url'],(($fuzz['rss'])?'RSS post':'Fuzz post').": {$url['title']}",1);
		}else{
			$post=get_post($id);
			$title=$comment=$post->post_title;
			$tags=str_replace(' ',',',$title);
			$perma=get_permalink($id);
			if(method_exists($sb,'shorten'))$perma=$sb->shorten($perma);
			$content=substr(t09_sb_sh(apply_filters('the_content',$post->post_content)),0,150).'...';
			$content.="<br/><a href=\"$perma\">$title</a>";
		}
		if(method_exists($sb,'format')){
			switch(true){
				case ($acc['spin']):
				case ($fuzz&&$sb->opts['spinfuzz']):
					$tpl=$sb->format($acc['type'],null,array('title'=>$title,'clip'=>$content,'comment'=>$comment,'tags'=>$tags,'perma'=>$perma),$id,$fuzz);
					$title=$tpl['title'];
					$content=$tpl['clip'];
					$comment=$tpl['comment'];
					$tags=$tpl['tags'];
					$perma=$tpl['perma'];
				break;
			}
		}

		// 1. log in
		$cookie = tempnam("/tmp", "clipmarks");
		$url = "http://clipmarks.com/login.aspx";
		$args="chkLoginRememberMe=1&btnLogin=Login&txtLoginUsername=$u&txtLoginPassword=$p&hdnFormType=login";

		$ch = curl_init();

		if(method_exists($sb,'proxy'))$ch=$sb->proxy($ch);

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie);
		curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie);
		curl_setopt($ch, CURLOPT_COOKIESESSION, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,true);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10 (.NET CLR 3.5.30729)');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $args);
		$b0 = curl_exec($ch);

		if(!$b0){
			$sb->sblog(null,"No response from clipmarks.com, user: $u",1);
			exit();
		}

		// post content
		$p=explode('/',$perma);
		$protocol=array_shift($p);
		array_shift($p);
		$host=array_shift($p);
		$path='/'.implode('/',$p);

		$args='<elements version="FF 4.0.1"><client><userAgent>Mozilla/5.0 (Windows; U; Windows NT 6.0; en-GB; rv:1.9.2.10) Gecko/20100914 Firefox/3.6.10 (.NET CLR 3.5.30729)</userAgent></client><frame type="IHTMLTxtRange" background-color="" clip-index="0"><source><base-href/><protocol>'.$protocol.'</protocol><host>'.$host.'</host><path>'.$path.'</path><page/><query/></source><content height="25" width="650" text-color="" link-color="" vlink-color=""><![CDATA['.$content.']]></content></frame></elements>';

		$url='http://clipmarks.com/clip_mozilla_save.aspx';
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $args);
		$b1 = curl_exec($ch);

		$str='@>([^<]+)<@si';
		preg_match($str,$b1,$m);
		$guid=$m[1];
		if(!$guid){
			$sb->sblog(null,"No guid from clipmarks.com, user: $u",1);
			exit();
		}

		$url='http://clipmarks.com/edit_clip.aspx?clipping=true&clip_guid='.$guid;
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HTTPGET, true);
		$b2 = curl_exec($ch);

		$str='@id="__VIEWSTATE" value="([^"]+)"@si';
		preg_match($str,$b2,$m);
		$vs=urlencode($m[1]);
		if(!$vs){
			$sb->sblog(null,"No VIEWSTATE from clipmarks.com, user: $u",1);
			exit();
		}

		$title=urlencode(html_entity_decode($title));
		$comment=urlencode($comment);
		$clip=$content;
		$tags=urlencode('a,b,c');
		$args="__VIEWSTATE=$vs&txtClipGUID=$guid&hdnPublic=1&txtInLibrary=1&txtTitle=$title&txtDescription=$comment&txtTags=$tags&hdnBackgroundColor=&hdnBkConfigured=0&btnDone=Done&nav=&new=&submitted=1";
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $args);
		$b3 = curl_exec($ch);
	}
	function t09_sb_clipmarks_widget($id,$acc,$sb){
		$img=$sb->base.'/Icons/clipmarks.16x16.png';
		echo '<li><img src="'.$img.'" align="middle"> &nbsp;<a href="http://clipmarks.com/clipper/'.$acc['user'].'/">clipmarks.com/'.$acc['user'].'</a></li>';
	}

?>