<?php

add_action('init','of_options');

if (!function_exists('of_options')) {
function of_options(){
	
// VARIABLES
$themename = get_theme_data(STYLESHEETPATH . '/style.css');
$themename = 'Site Options';
$shortname = "of";

// Populate OptionsFramework option in array for use in theme
global $of_options;
$of_options = get_option('of_options');

$GLOBALS['template_path'] = OF_DIRECTORY;

//Access the WordPress Categories via an Array
$of_categories = array();  
$of_categories_obj = get_categories('hide_empty=0');
foreach ($of_categories_obj as $of_cat) {
    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
$categories_tmp = array_unshift($of_categories, "Select a category:");    
       
//Access the WordPress Pages via an Array
$of_pages = array();
$of_pages_obj = get_pages('sort_column=post_parent,menu_order');    
foreach ($of_pages_obj as $of_page) {
    $of_pages[$of_page->ID] = $of_page->post_name; }
$of_pages_tmp = array_unshift($of_pages, "Select a page:");       

// Image Alignment radio box
$options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 

// Image Links to Options
$options_image_link_to = array("image" => "The Image","post" => "The Post"); 

//Testing 
$options_select = array("one","two","three","four","five"); 
$options_radio = array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five"); 


//More Options
$uploads_arr = wp_upload_dir();
$all_uploads_path = $uploads_arr['path'];
$all_uploads = get_option('of_uploads');
$other_entries = array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
$body_repeat = array("no-repeat","repeat-x","repeat-y","repeat");
$body_pos = array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");

// Set the Options Array
$options = array();

// General Options
$options[] = array( "name" => "General Settings",
                    "type" => "heading");

$options[] = array( "name" => "Custom Logo",
					"desc" => "Upload a logo for your theme, or specify the image address of your online logo. (http://yoursite.com/logo.png)",
					"id" => $shortname."_logo",
					"std" => "",
					"type" => "upload");

$options[] = array( "name" => "Custom Favicon",
					"desc" => "Upload a 16px x 16px Png/Gif image that will represent your website's favicon.",
					"id" => $shortname."_custom_favicon",
					"std" => "",
					"type" => "upload");
					
$options[] = array( "name" => "Show Phone/Email",
					"desc" => "Would you like to show you phone number and email in the header?",
					"id" => $shortname."_show_phone_email",
					"std" => "false",
					"type" => "checkbox");					 
					
$options[] = array( "name" => "Phone Number",
					"desc" => "Enter your phone number.",
					"id" => $shortname."_top_phone",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Your Email",
					"desc" => "Enter your email address.",
					"id" => $shortname."_top_email",
					"std" => "",
					"type" => "text");										

$options[] = array( "name" => "Copyright text",
					"desc" => "Enter your custom copyright text.",
					"id" => $shortname."_foot_copy",
					"std" => "",
					"type" => "text");
                                               
$options[] = array( "name" => "Tracking Code",
					"desc" => "Paste your Google Analytics (or other) tracking code here. This will be added into the header are of your site.",
					"id" => $shortname."_google_analytics",
					"std" => "",
					"type" => "textarea"); 

// Sliders
$options[] = array( "name" => "Home Slider",
					"type" => "heading");

$options[] = array( "name" => "Use The Slider",
					"desc" => "Would you like to use the Nivo Slider on the Home page?",
					"id" => $shortname."_show_home_slider",
					"std" => "false",
					"type" => "checkbox");
					
$options[] = array( "name" => "Big Intro Text",
					"desc" => "The large text above slider.",
					"id" => $shortname."_slider_big_text",
					"std" => "",
					"type" => "text");						
					
$options[] = array( "name" => "Slider Link Text",
					"desc" => "The text for your link. Same for all links.",
					"id" => $shortname."_slider_link_text",
					"std" => "",
					"type" => "text");					

$options[] = array( "name" => "Slider Image 1",
					"desc" => "Upload and select and image, or paste the url to an image you want to use. ",
					"id" => $shortname."_slider_image_1",
					"std" => "",
					"type" => "upload");

$options[] = array( "name" => "Slider Image 1 Title",
					"desc" => "The title that displays over the image. ",
					"id" => $shortname."_slider_image_1_title",
					"std" => "",
					"type" => "textarea");

$options[] = array( "name" => "Slider Image 1 URL",
					"desc" => "The url this image links to.",
					"id" => $shortname."_slider_image_1_url",
					"std" => "",
					"type" => "text");

$options[] = array( "name" => "Slider Image 2",
					"desc" => "Upload and select and image, or paste the url to an image you want to use. ",
					"id" => $shortname."_slider_image_2",
					"std" => "",
					"type" => "upload");

$options[] = array( "name" => "Slider Image 2 Title",
					"desc" => "The title that displays over the image. ",
					"id" => $shortname."_slider_image_2_title",
					"std" => "",
					"type" => "textarea");

$options[] = array( "name" => "Slider Image 2 URL",
					"desc" => "The url this image links to.",
					"id" => $shortname."_slider_image_2_url",
					"std" => "",
					"type" => "text");

$options[] = array( "name" => "Slider Image 3",
					"desc" => "Upload and select and image, or paste the url to an image you want to use. ",
					"id" => $shortname."_slider_image_3",
					"std" => "",
					"type" => "upload");


$options[] = array( "name" => "Slider Image 3 Title",
					"desc" => "The title that displays over the image. ",
					"id" => $shortname."_slider_image_3_title",
					"std" => "",
					"type" => "textarea");

$options[] = array( "name" => "Slider Image 3 URL",
					"desc" => "The url this image links to.",
					"id" => $shortname."_slider_image_3_url",
					"std" => "",
					"type" => "text");

$options[] = array( "name" => "Slider Image 4",
					"desc" => "Upload and select and image, or paste the url to an image you want to use. ",
					"id" => $shortname."_slider_image_4",
					"std" => "",
					"type" => "upload");

$options[] = array( "name" => "Slider Image 4 Title",
					"desc" => "The title that displays under the image. ",
					"id" => $shortname."_slider_image_4_title",
					"std" => "",
					"type" => "textarea");

$options[] = array( "name" => "Slider Image 4 URL",
					"desc" => "The url this image links to.",
					"id" => $shortname."_slider_image_4_url",
					"std" => "",
					"type" => "text");

$options[] = array( "name" => "Slider Image 5",
					"desc" => "Upload and select and image, or paste the url to an image you want to use. ",
					"id" => $shortname."_slider_image_5",
					"std" => "",
					"type" => "upload");

$options[] = array( "name" => "Slider Image 5 Title",
					"desc" => "The title that displays over the image. ",
					"id" => $shortname."_slider_image_5_title",
					"std" => "",
					"type" => "textarea");

$options[] = array( "name" => "Slider Image 5 URL",
					"desc" => "The url this image links to.",
					"id" => $shortname."_slider_image_5_url",
					"std" => "",
					"type" => "text");
					
// 3 Boxes
$options[] = array( "name" => "3 boxes",
                    "type" => "heading");	
					
$options[] = array( "name" => "Show 3 Feature Boxes",
					"desc" => "Do you want to show the 3 feature boxes on the home page?",
					"id" => $shortname."_feature_boxes_home",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => "Feature Box Heading",
					"desc" => "Enter the text you want that will be large.",
					"id" => $shortname."_feat_box_head",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Box 1 Title",
					"desc" => "Enter a title for the first box.",
					"id" => $shortname."_feat_box_one_tit",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Box 1 Text",
					"desc" => "Enter some text for the first box.",
					"id" => $shortname."_feat_box_one_txt",
					"std" => "",
					"type" => "text");						
					
$options[] = array( "name" => "Box 1 Image",
					"desc" => "Add an image for the first box.",
					"id" => $shortname."_feat_box_one_img",
					"std" => "",
					"type" => "upload");	
					
$options[] = array( "name" => "Box 1 Link URL",
					"desc" => "Add a url for the first box button.",
					"id" => $shortname."_feat_box_one_lnk",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Box 1 Link Text",
					"desc" => "Add some text for the first box button.",
					"id" => $shortname."_feat_box_one_lnktxt",
					"std" => "",
					"type" => "text");
					
$options[] = array( "name" => "Box 2 Title",
					"desc" => "Enter a title for the second box.",
					"id" => $shortname."_feat_box_two_tit",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Box 2 Text",
					"desc" => "Enter some text for the second box.",
					"id" => $shortname."_feat_box_two_txt",
					"std" => "",
					"type" => "text");						
					
$options[] = array( "name" => "Box 2 Image",
					"desc" => "Add an image for the second box.",
					"id" => $shortname."_feat_box_two_img",
					"std" => "",
					"type" => "upload");	
					
$options[] = array( "name" => "Box 2 Link URL",
					"desc" => "Add a url for the second box button.",
					"id" => $shortname."_feat_box_two_lnk",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Box 2 Link Text",
					"desc" => "Add some text for the second box button.",
					"id" => $shortname."_feat_box_two_lnktxt",
					"std" => "",
					"type" => "text");
					
$options[] = array( "name" => "Box 3 Title",
					"desc" => "Enter a title for the third box.",
					"id" => $shortname."_feat_box_three_tit",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Box 3 Text",
					"desc" => "Enter some text for the third box.",
					"id" => $shortname."_feat_box_three_txt",
					"std" => "",
					"type" => "text");						
					
$options[] = array( "name" => "Box 3 Image",
					"desc" => "Add an image for the third box.",
					"id" => $shortname."_feat_box_three_img",
					"std" => "",
					"type" => "upload");	
					
$options[] = array( "name" => "Box 3 Link URL",
					"desc" => "Add a url for the third box button.",
					"id" => $shortname."_feat_box_three_lnk",
					"std" => "",
					"type" => "text");	
					
$options[] = array( "name" => "Box 3 Link Text",
					"desc" => "Add some text for the third box button.",
					"id" => $shortname."_feat_box_three_lnktxt",
					"std" => "",
					"type" => "text");		
					
// Home Content
$options[] = array( "name" => "Home Content",
					"type" => "heading");

$options[] = array( "name" => "Custom Content Box",
					"desc" => "Do you want to show the custom content area on the home page?",
					"id" => $shortname."_home_custom",
					"std" => "false",
					"type" => "checkbox");	
					
$options[] = array( "name" => "Content Box Heading",

					"desc" => "Enter the text you want that will be large. ",
					"id" => $shortname."_home_custom_text",
					"std" => "",
					"type" => "text");																																																								

// Blog Options
$options[] = array( "name" => "Blog Options",
					"type" => "heading");

$options[] = array( "name" => "Show Blog Masthead",
					"desc" => "Do you want to show the masthead intro on your blog page?",
					"id" => $shortname."_blog_masthead",
					"std" => "false",
					"type" => "checkbox");

$options[] = array( "name" => "Blog Masthead Text",

					"desc" => "Enter the text you want that will be large. ",
					"id" => $shortname."_blog_masthead_text",
					"std" => "",
					"type" => "text");													


// Update the options
update_option('of_template',$options); 					  
update_option('of_themename',$themename);   
update_option('of_shortname',$shortname);

}
}
?>
