<?php /* Start loop */ ?>
<?php while (have_posts()) : the_post(); ?>
	<article <?php post_class() ?> id="post-<?php the_ID(); ?>">
		<div class="entry-content">
			<?php if (has_post_thumbnail()) : // If the post has a Featured Image ?>
            <?php
            $thumb = get_post_thumbnail_id(); 
            $postimage = vt_resize($thumb, '', 599, 300, true );
            ?>
            <img class="postimg" src="<?php echo $postimage[url]; ?>" width="<?php echo $postimage[width]; ?>" height="<?php echo $postimage[height]; ?>" alt="<?php the_title(); ?>" />
            <?php endif; ?>
            
			<?php the_content(); ?>
		</div>
        <header>
			<?php reverie_entry_meta(); ?>
		</header>
		<footer>
			<?php wp_link_pages(array('before' => '<nav id="page-nav"><p>' . __('Pages:', 'reverie'), 'after' => '</p></nav>' )); ?>
			<p><?php the_tags(); ?></p>
		</footer>
		<?php comments_template(); ?>
	</article>
<?php endwhile; // End the loop ?>