<?php /* If there are no posts to display, such as an empty archive page */ ?>
<?php if (!have_posts()) : ?>
	<div class="notice">
		<p class="bottom"><?php _e('Sorry, no results were found.', 'reverie'); ?></p>
	</div>
	<?php get_search_form(); ?>	
<?php endif; ?>

<?php /* Start loop */ ?>
<?php while (have_posts()) : the_post(); ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<header>            
			<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
			<?php reverie_entry_meta(); ?>
		</header>
		<div class="entry-content">
            <?php if (has_post_thumbnail()) : // If the post has a Featured Image ?>
            <?php
            $thumb = get_post_thumbnail_id(); 
            $postimage = vt_resize($thumb, '', 599, 300, true );
            ?>
            <figure><a class="featured-image" href="<?php the_permalink(); ?>"><img src="<?php echo $postimage[url]; ?>" width="<?php echo $postimage[width]; ?>" height="<?php echo $postimage[height]; ?>" alt="<?php the_title(); ?>" /></a></figure>
            <?php endif; ?>
		<?php if (is_archive() || is_search()) : // Only display excerpts for archives and search ?>
            <?php the_excerpt(); ?>
        <?php else : ?>
            <?php the_content('Continue reading...'); ?>
        <?php endif; ?>
		</div>
	</article>	
<?php endwhile; // End the loop ?>

<?php /* Display navigation to next/previous pages when applicable */ ?>
<?php if ($wp_query->max_num_pages > 1) : ?>
		<?php if (function_exists("pagination")) { pagination($additional_loop->max_num_pages); } ?>
        <div class="clear"></div>
<?php endif; ?>