<?php

/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * Jom Social Component Controller
 */
class RioconstructControllerDueschedule extends RioconstructController {

    public function __construct() {
        parent::__construct();
    }

    function save() {
        $detail = JRequest::get('POST');
        $final_result['ID'] = $detail['ID'];
        $final_result['DUE_NAME'] = $detail['DUE_NAME'];
        $final_result['DUE_PRJ_NAME'] = trim($detail['DUE_PRJ_NAME']);
        $final_result['DUE_SCHEDULE'] = serialize($detail['DUE_SCHEDULE']);
        $model = & $this->getModel('dueschedule');
        $model->saveDueschedule($final_result);
        $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=dueschedule', 'Project Saved!');
    }

    function cancel() {
        $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=dueschedule', 'Cancelled...');
    }

    function remove() {
        $arrayIDs = JRequest::getVar('cid', null, 'default', 'array'); //Reads cid as an array
        if ($arrayIDs[0] === null) { //Make sure the cid parameter was in the request
            JError::raiseError(500, 'cid parameter missing from the request');
        }
        $model = & $this->getModel('dueschedule');
        $model->deleteDueschedule($arrayIDs);
        $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=dueschedule', 'Deleted...');
    }

}