<?php

/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

/**
 * Jom Social Component Controller
 */
class RioconstructControllerPastproject extends RioconstructController {

    public function __construct() {
        parent::__construct();
    }

    function save() {
        $detail = JRequest::get('POST');
        $model = & $this->getModel('pastproject');
        if ($model->saveproject($detail) == 1) {
            $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=pastproject', 'Project Saved!');
        }
    }

    function publish() {
        $detail = JRequest::get('POST');
        $model = & $this->getModel('pastproject');
        $model->pubproject($detail);
        $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=pastproject', 'Pulished...');
    }

    function unpublish() {
        $detail = JRequest::get('POST');
        $model = & $this->getModel('pastproject');
        $model->pubproject($detail);
        $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=pastproject', 'UnPulished...');
    }

    function cancel() {
        $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=pastproject', 'Cancelled...');
    }

    function remove() {
        $arrayIDs = JRequest::getVar('cid', null, 'default', 'array'); //Reads cid as an array
        if ($arrayIDs[0] === null) { //Make sure the cid parameter was in the request
            JError::raiseError(500, 'cid parameter missing from the request');
        }
        $model = & $this->getModel('pastproject');
        $model->deleteproject($arrayIDs);
        $this->setRedirect('index.php?option=' . JRequest::getVar('option') . '&view=pastproject', 'Deleted...');
    }

}