<?php

/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
jimport('joomla.filesystem.file');

class RioconstructModelCurrentproject extends JModel {

    /**
     * Configuration data
     * 
     * @var object	JPagination object
     * */
    var $_pagination;
    /**
     * Configuration data
     * 
     * @var int	Total number of rows
     * */
    var $_total;
    /**
     * Configuration data
     * 
     * @var int	Total number of rows
     * */
    var $_data;

    /**
     * Constructor
     */
    public function __construct() {
        $mainframe = JFactory::getApplication();

        // Call the parents constructor
        parent::__construct();

        // Get the pagination request variables
        $limit = $mainframe->getUserStateFromRequest('com_rioconstruct.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        //$limitstart	= $mainframe->getUserStateFromRequest( 'com_rioconstruct.limitstart', 'limitstart', 0, 'int' );
        $limitstart = JRequest::getVar('limitstart', 0);

        // In case limit has been changed, adjust limitstart accordingly
        $limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

        $this->setState('limit', $limit);
        $this->setState('limitstart', $limitstart);
    }

    /**
     * Method to get a pagination object for the events
     *
     * @access public
     * @return integer
     */
    public function getPagination() {
        // Lets load the content if it doesn't already exist
        if (empty($this->_pagination)) {
            jimport('joomla.html.pagination');
            $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit'));
        }

        return $this->_pagination;
    }

    /**
     * Method to return the total number of rows
     *
     * @access public
     * @return integer
     */
    public function getTotal() {
        // Load total number of rows
        if (empty($this->_total)) {
            $this->_total = $this->_getListCount($this->_buildQuery());
        }
        return $this->_total;
    }

    /**
     * Build the SQL query string
     *
     * @access	private
     * @return	string	SQL Query string	 
     */
    public function _buildQuery() {

        $arrayIDs = JRequest::getVar('cid', null, 'default', 'array');
        $where = ' WHERE PRJ_PROJECT_TYPE=1';

        $db = JFactory::getDBO();
        $mainframe = JFactory::getApplication();
        $ordering = $mainframe->getUserStateFromRequest($option . 'filter_order', 'filter_order', 'ID', 'cmd');
        $orderDirection = $mainframe->getUserStateFromRequest($option . 'filter_order', 'filter_order_Dir', '', 'word');
        $orderby = ' ORDER BY ' . $ordering . ' ' . $orderDirection;
        if (isset($arrayIDs[0])) {
            $where = ' AND ID = ' . $arrayIDs[0];
            $orderby = '';
        }
        $query = 'SELECT * FROM ' . $db->nameQuote('#__rio_projects')
                . $where
                . $orderby;
        return $query;
    }

    /**
     * Returns the Groups Categories list
     *
     * @return Array An array of group category objects
     * */
    public function getCurrentproject() {
        $mainframe = JFactory::getApplication();

        if (empty($this->_data)) {
            $query = $this->_buildQuery();
            $this->_data = $this->_getList($this->_buildQuery(), $this->getState('limitstart'), $this->getState('limit'));
        }
        return $this->_data;
    }

    /**
     * Returns the Groups Categories list
     *
     * @return Array An array of group category objects
     * */
    public function getCurrentprojectCount() {
        $db = JFactory::getDBO();

        $query = 'SELECT `ID`, COUNT(*) AS `count` FROM ' . $db->nameQuote('#__rio_projects');
        $db->setQuery($query);
        $result = $db->loadObjectList('ID');

        return $result;
    }

    function pubproject($arrayIDs) {

        if ($arrayIDs['task'] == "publish") {
            $publish = 1;
        } else {
            $publish = 0;
        }
        foreach ($arrayIDs['cid'] as $Id) {
            $query = "UPDATE #__rio_projects set PULISHED=" . $publish . " WHERE ID=" . $Id;
            $db = $this->getDBO();
            $db->setQuery($query);
            $db->query();
            
        }
    }
    
    function movepast($details) {
       
        foreach ($details['cid'] as $Id) {
        $query = "UPDATE #__rio_projects set PRJ_PROJECT_TYPE=0 WHERE ID=" . $Id;
        $db = $this->getDBO();
        $db->setQuery($query);
        $db->query();
        }
    }

    function deleteproject($arrayIDs) {

        foreach ($arrayIDs as $Id) {
            $query = "DELETE FROM #__rio_projects WHERE ID=" . $Id;
            $db = $this->getDBO();
            $db->setQuery($query);
            $db->query();
        }
    }

    function saveproject($detail) {
        $query = "SELECT ID FROM #__rio_projects ORDER BY  ID DESC LIMIT 0 , 1";
        $db = $this->getDBO();
        $db->setQuery($query);
        $lastId = $db->loadObject();

        if ($this->riofile_upload($lastId->ID + 1) == 1) {
            $detailTableRow = & $this->getTable('currentproject');
            if (!$detailTableRow->bind($detail)) {
                JError::raiseError(500, 'Error binding data');
            }
            if (!$detailTableRow->check()) {
                JError::raiseError(500, 'Invalid data');
            }
            if (!$detailTableRow->store()) {
                $errorMessage = $detailTableRow->getError();
                JError::raiseError(500, 'Error binding data: ' . $errorMessage);
            }
        } else {
            return 0;
        }
        return 1;
    }

    function riofile_upload($projectId) { 
        $task = JRequest::getCmd('task');

        $projectFolder = CONSTRUCT_BASE_ASSETS_PATH . DS . 'uploads' . DS . 'Project-' . $projectId;

        $thumbfile = JRequest::getVar('Thumb_Image', null, 'files');

        if ($thumbfile['error'] == 0) {
            //Clean up filename to get rid of strange characters like spaces etc
            $filename = JFile::makeSafe($thumbfile['name']);

            //Set up the source and destination of the file
            $src = $thumbfile['tmp_name'];

            $dest = $projectFolder . DS . 'thumb.' . JFile::getExt($filename);
            if (JFile::getExt($filename) == 'jpg' || JFile::getExt($filename) == 'jpeg' || JFile::getExt($filename) == 'bmp') {
                if ($task != 'edit') {
                    JFolder::create($projectFolder, '777');
                }
                if (!JFile::upload($src, $dest)) { 
                    return 0;
                }
            }
        }

        $prjgallery = JRequest::getVar('prg_gallery', null, 'files');
        if ($prjgallery['error'][0] == 0) {

            if ($task != 'edit') {
                JFolder::create($projectFolder . DS . 'Gallery', '777');
            }

            $n = count($prjgallery['name']);
            
            for ($i = 0; $i < $n; $i++) {

                //Clean up filename to get rid of strange characters like spaces etc
                $filename = JFile::makeSafe($prjgallery['name'][$i]);

                //Set up the source and destination of the file
                $src = $prjgallery['tmp_name'][$i];

                $dest = $projectFolder . DS . 'Gallery' . DS . $filename;
                if (JFile::getExt($filename) == 'jpg' || JFile::getExt($filename) == 'jpeg' || JFile::getExt($filename) == 'bmp') {

                    if (!JFile::upload($src, $dest)) {
                        return 0;
                    }
                }
            }
        }
        
        return 1;
    }

}