<?php

/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
jimport('joomla.filesystem.file');

class RioconstructModelPayment extends JModel {

    /**
     * Configuration data
     * 
     * @var object	JPagination object
     * */
    var $_pagination;
    /**
     * Configuration data
     * 
     * @var int	Total number of rows
     * */
    var $_total;
    /**
     * Configuration data
     * 
     * @var int	Total number of rows
     * */
    var $_data;

    /**
     * Constructor
     */
    public function __construct() {
        $mainframe = JFactory::getApplication();

        // Call the parents constructor
        parent::__construct();

        // Get the pagination request variables
        $limit = $mainframe->getUserStateFromRequest('com_rioconstruct.limit', 'limit', $mainframe->getCfg('list_limit'), 'int');
        //$limitstart	= $mainframe->getUserStateFromRequest( 'com_rioconstruct.limitstart', 'limitstart', 0, 'int' );
        $limitstart = JRequest::getVar('limitstart', 0);

        // In case limit has been changed, adjust limitstart accordingly
        $limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

        $this->setState('limit', $limit);
        $this->setState('limitstart', $limitstart);
    }

    /**
     * Method to get a pagination object for the events
     *
     * @access public
     * @return integer
     */
    public function getPagination() {
        // Lets load the content if it doesn't already exist
        if (empty($this->_pagination)) {
            jimport('joomla.html.pagination');
            $this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit'));
        }

        return $this->_pagination;
    }

    /**
     * Method to return the total number of rows
     *
     * @access public
     * @return integer
     */
    public function getTotal() {
        // Load total number of rows
        if (empty($this->_total)) {
            $this->_total = $this->_getListCount($this->_buildQuery());
        }
        return $this->_total;
    }

    /**
     * Build the SQL query string
     *
     * @access	private
     * @return	string	SQL Query string	 
     */
    public function _buildQuery() {

        $arrayIDs = JRequest::getVar('cid', null, 'default', 'array');
        $where = '';

        $db = JFactory::getDBO();
        $mainframe = JFactory::getApplication();
        $ordering = $mainframe->getUserStateFromRequest($option . 'filter_order', 'filter_order', 'ID', 'cmd');
        $orderDirection = $mainframe->getUserStateFromRequest($option . 'filter_order', 'filter_order_Dir', '', 'word');
        $orderby = ' ORDER BY ' . $ordering . ' ' . $orderDirection;
        if (isset($arrayIDs[0])) {
            $where = ' WHERE ID = ' . $arrayIDs[0];
            $orderby = '';
        }
        $query = 'SELECT * FROM ' . $db->nameQuote('#__rio_payment')
                . $where
                . $orderby;
        return $query;
    }

    /**
     * Returns the Groups Categories list
     *
     * @return Array An array of group category objects
     * */
    public function getpayment() {
        $mainframe = JFactory::getApplication();

        if (empty($this->_data)) {
            $query = $this->_buildQuery();
            $this->_data = $this->_getList($this->_buildQuery(), $this->getState('limitstart'), $this->getState('limit'));
        }
        return $this->_data;
    }

    /**
     * Returns the Groups Categories list
     *
     * @return Array An array of group category objects
     * */
    public function getpaymentCount() {
        $db = JFactory::getDBO();

        $query = 'SELECT `ID`, COUNT(*) AS `count` FROM ' . $db->nameQuote('#__rio_payment');
        $db->setQuery($query);
        $result = $db->loadObjectList('ID');

        return $result;
    }

    function deletepayment($arrayIDs) {

        foreach ($arrayIDs as $Id) {
            $query = "DELETE FROM #__rio_payment WHERE ID=" . $Id;
            $db = $this->getDBO();
            $db->setQuery($query);
            $db->query();
        }
    }
    
    function getcustomerlist(){
        $db = JFactory::getDBO();

        $query = 'SELECT ID, CS_F_NAME FROM ' . $db->nameQuote('#__rio_customers');
        $db->setQuery($query);
        $result = $db->loadObjectList();

        return $result;
    }

    function savepayment($detail) {
        $detailTableRow = & $this->getTable('payment');
        if (!$detailTableRow->bind($detail)) {
            JError::raiseError(500, 'Error binding data');
        }
        if (!$detailTableRow->check()) {
            JError::raiseError(500, 'Invalid data');
        }
        if (!$detailTableRow->store()) {
            $errorMessage = $detailTableRow->getError();
            JError::raiseError(500, 'Error binding data: ' . $errorMessage);
        }
    }

}