<?php

/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

// @todo: Do some check if user is really allowed to access this section of the back end.
// Just in case we need to impose ACL on the component
// During ajax calls, the following constant might not be called
if (!defined('JPATH_COMPONENT')) {
    define('JPATH_COMPONENT', dirname(__FILE__));
}

// Load any defined properties
require_once( JPATH_COMPONENT . DS . 'defines.php' );

// Require the base controller
require_once( JPATH_COMPONENT . DS . 'controllers' . DS . 'controller.php' );

// Set the tables path
JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_rioconstruct'.DS.'tables');

// Get the task
$task = JRequest::getCmd('task', 'display');
// We treat the view as the controller. Load other controller if there is any.
$controller = JRequest::getWord('view', 'home');

if (!empty($controller)) {
    $controller = JString::strtolower($controller);
    $path = CONSTRUCT_CONTROLLERS . DS . $controller . '.php';

    // Test if the controller really exists
    if (file_exists($path)) {
        require_once( $path );
    } else {
        JError::raiseError(500, JText::_('com_rioconstruct_CONTROLLER_NOT_EXISTS'));
    }
}

$class = 'RioconstructController' . JString::ucfirst($controller);
// Test if the object really exists in the current context
if (class_exists($class)) {
    $controller = new $class();
} else {
    // Throw some errors if the system is unable to locate the object's existance
    JError::raiseError(500, 'Invalid Controller Object. Class definition does not exists in this context.');
}
// Task's are methods of the controller. Perform the Request task
$controller->execute($task);

// Redirect if set by the controller
$controller->redirect();
