<?php

/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

/**
 * Configuration view for Jom Social
 */
class RioconstructViewCustomer extends JView {

    /**
     * The default method that will display the output of this view which is called by
     * Joomla
     * 
     * @param	string template	Template file name
     * */
    public function display($tpl = null) {
        $mainframe = JFactory::getApplication();
        $task = JRequest::getCmd('task');
        $filter_order = $mainframe->getUserStateFromRequest("com_rioconstruct.customer.filter_order", 'filter_order', 'name', 'cmd');
        $filter_order_Dir = $mainframe->getUserStateFromRequest("com_rioconstruct.customer.filter_order_Dir", 'filter_order_Dir', '', 'word');


        // table ordering
        $lists['order_Dir'] = $filter_order_Dir;
        $lists['order'] = $filter_order;

        $customer = $this->get('customer');
        $pagination = $this->get('Pagination');
        $customerCount = $this->get('customerCount');
        $this->assignRef('lists', $lists);
        $this->assignRef('customer', $customer);
        $this->assignRef('customerCount', $customerCount);
        $this->assignRef('pagination', $pagination);

        if ($task == 'add') {
            $tpl = 'new';
        } else if ($task == 'edit') {
            $tpl = 'edit';
        } else if ($task == 'schedule') {
            $tpl = 'schedule';
        }

        parent::display($tpl);
    }

    public function setToolBar() {

        $task = JRequest::getCmd('task');

        switch ($task) {
            case 'add':

                JToolBarHelper::title('New Customer');
                JToolBarHelper::save();
                JToolBarHelper::cancel();
                break;

            case 'edit':

                JToolBarHelper::title('Edit Customer');
                JToolBarHelper::save();
                JToolBarHelper::apply();
                JToolBarHelper::cancel();
                break;
            
            case 'schedule':
                JToolBarHelper::title('Schedule Making');
                JToolBarHelper::custom($task='assignSchedule', $icon='makeschedule', $iconOver='makeschedule', $alt='Make Schedule', false);
                JToolBarHelper::cancel();
                break;

            default:                // Set the titlebar text
                JToolBarHelper::title(JText::_('Customer List'), 'customer');

                // Add the necessary buttons
                JToolBarHelper::back(JText::_('Home'), 'index.php?option=com_rioconstruct');
                JToolBarHelper::divider();
                JToolBarHelper::custom($task='schedule', $icon='schedule', $iconOver='schedule', $alt='schedule', false);
                JToolBarHelper::divider();
                JToolBarHelper::deleteList();
                JToolBarHelper::editListX();
                JToolBarHelper::addNewX();
        }
    }

}