<?php
/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

/**
 * Configuration view for Jom Social
 */
class RioconstructViewHome extends JView {

    /**
     * The default method that will display the output of this view which is called by
     * Joomla
     * 
     * @param	string template	Template file name
     * */
    public function display($tpl = null) {
        JHTML::_('behavior.tooltip', '.hasTip');
        jimport('joomla.html.pane');
        $pane = & JPane::getInstance('sliders');


        $this->assignRef('pane', $pane);
        parent::display($tpl);
    }

    public function addIcon($image, $url, $text, $newWindow = false) {
        $lang = & JFactory::getLanguage();
        $newWindow = ( $newWindow ) ? ' target="_blank"' : '';
        ?>
        <div style="float:<?php echo ($lang->isRTL()) ? 'right' : 'left'; ?>;">
            <div class="icon">
                <a href="<?php echo $url; ?>"<?php echo $newWindow; ?>>
                    <?php echo JHTML::_('image', 'administrator/components/com_rioconstruct/assets/icons/' . $image, NULL, NULL); ?>
                    <span><?php echo $text; ?></span></a>
            </div>
        </div>
        <?php
    }

    public function setToolBar() {
        // Set the titlebar text
        JToolBarHelper::title(JText::_('Construction'), 'Rioconstruct');
    }

}