<?php

/**
 * @category	Core
 * @package		JomSocial
 * @copyright (C) 2008 by Slashes & Dots Sdn Bhd - All rights reserved!
 * @license		GNU/GPL, see LICENSE.php
 */
// Disallow direct access to this file
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

/**
 * Configuration view for Jom Social
 */
class RioconstructViewPastproject extends JView {

    /**
     * The default method that will display the output of this view which is called by
     * Joomla
     * 
     * @param	string template	Template file name
     * */
    public function display($tpl = null) {
        $mainframe = JFactory::getApplication();
        $task = JRequest::getCmd('task');
        $filter_order = $mainframe->getUserStateFromRequest("com_rioconstruct.currentproject.filter_order", 'filter_order', 'name', 'cmd');
        $filter_order_Dir = $mainframe->getUserStateFromRequest("com_rioconstruct.currentproject.filter_order_Dir", 'filter_order_Dir', '', 'word');


        // table ordering
        $lists['order_Dir'] = $filter_order_Dir;
        $lists['order'] = $filter_order;

        $pastproject = $this->get('Pastproject');
        $pagination = $this->get('Pagination');
        $projCount = $this->get('pastprojectCount');
        $this->assignRef('lists', $lists);
        $this->assignRef('pastproject', $pastproject);
        $this->assignRef('projCount', $projCount);
        $this->assignRef('pagination', $pagination);

        if ($task == 'add') {
            $tpl = 'new';
        } else if ($task == 'edit') {
            $tpl = 'edit';
        }

        parent::display($tpl);
    }

    public function setToolBar() {

        $task = JRequest::getCmd('task');

        switch ($task) {
            case 'add':

                JToolBarHelper::title('New Project');
                JToolBarHelper::save();
                JToolBarHelper::cancel();
                break;

            case 'edit':

                JToolBarHelper::title('Edit Project');
                JToolBarHelper::save();
                JToolBarHelper::apply();
                JToolBarHelper::cancel();
                break;

            default:                // Set the titlebar text
                JToolBarHelper::title(JText::_('Past Project List'), 'pastproject');

                // Add the necessary buttons
                JToolBarHelper::back(JText::_('Home'), 'index.php?option=com_rioconstruct');
                JToolBarHelper::divider();
                JToolBarHelper::publish();
                JToolBarHelper::unpublish();
                JToolBarHelper::deleteList();
                JToolBarHelper::editListX();
                JToolBarHelper::addNewX();
        }
    }

}