$(function(){
	
	$('#departments-nav li').hover(
		function() {
			$(this).stop().animate({ marginTop: -6 }, 200);
		}, 
		function() {
			$(this).stop().animate({ marginTop: 0 }, 200);
		}
	);
	
	$('.project-list').jcarousel({
		scroll: 1,
		buttonNextHTML: '<a></a>',
		buttonPrevHTML: '<a></a>'
	});
	
	// Project Hover Effect
	$('.project-list .project-container a').live('mouseenter',
		function () {
			$(this).children('div').stop(true, true).animate({ 'opacity': 1 });
		}
	).live('mouseleave',
		function () {
			$(this).children('div').stop(true, true).animate({ 'opacity': 0 });
		}
	);
	
	$('a[rel=external]').live('click', function() {
		$('#sb-nav').css('z-index', 10);
	});
	
	// Open Projects Overview
	$('#projects-launch').click(function(e){
		e.preventDefault();
		if ($('section.content.overview').size() < 1) {
			$('<div class="projects-overview-container"></div>').appendTo('body');
			$('div.projects-overview-container').css('top', $(document).height());
			$('div.projects-overview-container').load($(this).attr('href') + ' section.content.overview', function (response){
				$('section.content.overview .project-list').jcarousel({
					scroll: 1,
					buttonNextHTML: '<a></a>',
					buttonPrevHTML: '<a></a>'
				});
				$('div.projects-overview-container').stop(true, true).animate({'top': 0});
			});
		} else {
			$('div.projects-overview-container').stop(true, true).animate({'top': 0});
		}
	});
	
	// Close Projects Overview
	$('#projects-hide').live('click', function(e){
		e.preventDefault();
		$('div.projects-overview-container').stop(true, true).animate({'top': $(document).height()});
	});
	
	// Load Project Page
	$('.project-list .project-container a').live('click', function(e){
		e.preventDefault();
		$(this).siblings('div').stop(true, true).fadeOut();
		if ($('section.content.project').size() < 1) {
			$(' <div class="project-detail-container"></div>').appendTo('body').css('display', 'none');
		}
		$('div.project-detail-container').load($(this).attr('href') + ' section.content.project', function (response){
			if ($('div.projects-overview-container').size() > 0) {
				$('div.projects-overview-container').stop(true, true).animate({'top': $(document).height()});
			}
			$('section.content.home').fadeOut('slow', function () {
				$('div.project-detail-container').fadeIn('slow', function () {
					Shadowbox.clearCache();
					Shadowbox.setup("ul.thumbnails a");
					Shadowbox.setup('a[rel=external]', {
						height: 600,
						width: 1024
					});
				});
			});
		});
	});
	
	// Change project
	$('#project-next, #project-prev').live('click', function (e) {
		e.preventDefault();
		if ($(this).hasClass('disabled')) { return false; }
		$('div.project-detail-container').fadeOut(function() {
			$('div.project-detail-container').load($(e.currentTarget).attr('href') + ' section.content.project', function (response){
				$('div.project-detail-container').fadeIn('slow', function () {
					Shadowbox.clearCache();
					Shadowbox.setup("ul.thumbnails a");
					Shadowbox.setup('a[rel=external]', {
						height: 600,
						width: 1024
					});
				});
			});
		});
	});
	
	// Project Thumbs Hover
	$('ul.thumbnails a').live('mouseenter',
		function () {
			$(this).prev('.hover').stop(true, true).animate({ 'opacity': 1 });
		}
	).live('mouseleave',
		function () {
			$(this).prev('.hover').stop(true, true).animate({ 'opacity': 0 });
		}
	);
	$('ul.thumbnails a').live('click', function() {
		$('#sb-nav').css('z-index', 100);
	});
	
	// Open Project Details
	$('#details-launch').live('click', function(e){
		e.preventDefault();
		$('#project-details').modal({
			onOpen: function (dialog) {
				dialog.overlay.fadeIn('slow');
				dialog.data.show();
				dialog.container.fadeIn('slow');
				Shadowbox.setup('a[rel=external]', {
					height: 600,
					width: 1024
				});
			},
			onClose: function (dialog) {
				dialog.container.fadeOut();
				dialog.overlay.fadeOut(function () {
					$.modal.close();
				});
			},
			overlayClose: true
		});
	});
	
	// Return to Home
	$('#project-back').live('click', function(e){
		e.preventDefault();
		$('div.project-detail-container').fadeOut(function() {
			$('section.content.home').fadeIn();
		});
	});
	
	Shadowbox.setup('a[rel=external]', {
		height: 600,
		width: 1024
	});
	
	$('#loading-mask').fadeOut(1400, function (){
		$(this).remove();
		if ($('#sb-container').size() > 0) {
			$('#sb-nav').appendTo($('#sb-wrapper-inner'));
		}
	})
	
});

Shadowbox.init({
	// skip the automatic setup again, we do this later manually
	skipSetup: true,
	displayCounter: false
});

function carouselPagesReload(carousel) {
	/*
	console.log('ancho contenedor: ' + $('section.content').width());
	console.log('ancho del project:' + $('section.content .project-container').width());
	console.log('calculo: ' + Math.round($('section.content').width() / $('section.content .project-container').width()));
	//*/
	carousel.options.scroll = Math.round($('section.content').width() / $('section.content .project-container').width());
}
