'**********************************************************
'* Demo for Standalone SDK.Created by Darcy on Dec.15 2009*
'**********************************************************

Public Class AttLogs
    Dim count, i As Integer
    Dim branchCode(500) As String
    Dim itemId As String
    Dim cmbBranchSelIndex As String
    Public cusDs As New DataSet
    Public cusDa As OleDb.OleDbDataAdapter
    'Create Standalone SDK class dynamicly.
    Public axCZKEM1 As New zkemkeeper.CZKEM

#Region "Communication"
    '*********************************************************************************************************************************************
    '* Before you refer to this demo,we strongly suggest you read the development manual deeply first.                                           *
    '* This part is for demonstrating the communication with your device.There are 3 communication ways: "TCP/IP","Serial Port" and "USB Client".*
    '* The communication way which you can use duing to the model of the device.                                                                 *
    '* *******************************************************************************************************************************************
    Private bIsConnected = False 'the boolean value identifies whether the device is connected
    Private iMachineNumber As Integer 'the serial number of the device.After connecting the device ,this value will be changed.

    'If your device supports the TCP/IP communications, you can refer to this.
    'when you are using the tcp/ip communication,you can distinguish different devices by their IP address.
    Private Sub btnConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConnect.Click
        If txtIP.Text.Trim() = "" Or txtPort.Text.Trim() = "" Then
            MsgBox("IP and Port cannot be null", MsgBoxStyle.Exclamation, "Error")
            Return
        End If
        Dim idwErrorCode As Integer
        Cursor = Cursors.WaitCursor
        If btnConnect.Text = "Disconnect" Then
            AxCZKEM1.Disconnect()
            bIsConnected = False
            btnConnect.Text = "Connect"
            lblState.Text = "Current State:Disconnected"
            Cursor = Cursors.Default
            Return
        End If

        bIsConnected = AxCZKEM1.Connect_Net(txtIP.Text.Trim(), Convert.ToInt32(txtPort.Text.Trim()))
        If bIsConnected = True Then
            btnConnect.Text = "Disconnect"
            btnConnect.Refresh()
            lblState.Text = "Current State:Connected"
            iMachineNumber = 1 'In fact,when you are using the tcp/ip communication,this parameter will be ignored,that is any integer will all right.Here we use 1.
            AxCZKEM1.RegEvent(iMachineNumber, 65535) 'Here you can register the realtime events that you want to be triggered(the parameters 65535 means registering all)
        Else
            AxCZKEM1.GetLastError(idwErrorCode)
            MsgBox("Unable to connect the device,ErrorCode=" & idwErrorCode, MsgBoxStyle.Exclamation, "Error")
        End If
        Cursor = Cursors.Default


    End Sub
  
#End Region

#Region "AttLogs"
    ' **************************************************************************************************
    ' * Before you refer to this demo,we strongly suggest you read the development manual deeply first.*
    ' * This part is for demonstrating operations with(read/get/clear) the attendance records.         *
    ' * ************************************************************************************************
    'Download the attendance records from the device.
    Private Sub btnGetGeneralLogData_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetGeneralLogData.Click
        ds.Reset()
        Sql = "SELECT ATN_BRANCH,ATN_MACHCODE,ATN_DATE, ATN_INTIME, ATN_OUTTIME, ATN_LATEBY, ATN_EARLYBY, MODIFIED_DATE, CREATED_DATE FROM ATTENDANCELOGS"
        da = New OleDb.OleDbDataAdapter(Sql, con)
        da.Fill(ds, DBNAME)
        If txtIP.Text.Trim() = "" Or txtPort.Text.Trim() = "" Then
            MsgBox("IP and Port cannot be null", MsgBoxStyle.Exclamation, "Error")
            Return
        End If

        'LOAD DATA FROM MACHINE TO DATABASE

        If bIsConnected = False Then
            MsgBox("Please connect the device first", MsgBoxStyle.Exclamation, "Error")
            Return
        End If

        Dim sdwEnrollNumber As String = ""
        Dim idwVerifyMode As Integer
        Dim idwInOutMode As Integer
        Dim idwYear As Integer
        Dim idwMonth As Integer
        Dim idwDay As Integer
        Dim idwHour As Integer
        Dim idwMinute As Integer
        Dim idwSecond As Integer
        Dim idwWorkcode As Integer

        Dim idwErrorCode As Integer
        Dim iGLCount = 0
        Dim lvItem As New ListViewItem("Items", 0)

        Cursor = Cursors.WaitCursor
        'lvLogs.Items.Clear()
        axCZKEM1.EnableDevice(iMachineNumber, False) 'disable the device
        If axCZKEM1.ReadGeneralLogData(iMachineNumber) And cmbBranchSelIndex <> -1 Then 'read all the attendance records to the memory
            'get records from the memory
            While axCZKEM1.SSR_GetGeneralLogData(iMachineNumber, sdwEnrollNumber, idwVerifyMode, idwInOutMode, idwYear, idwMonth, idwDay, idwHour, idwMinute, idwSecond, idwWorkcode)
                iGLCount += 1
                Dim cb As New OleDb.OleDbCommandBuilder(da)
                Dim dsNewRow As DataRow
                dsNewRow = ds.Tables(DBNAME).NewRow()
                dsNewRow.Item("ATN_BRANCH") = branchCode(cmbBranchName.SelectedIndex)
                dsNewRow.Item("ATN_MACHCODE") = sdwEnrollNumber
                dsNewRow.Item("ATN_DATE") = idwMonth.ToString() & "/" & idwDay.ToString() & "/" & idwYear.ToString()

                If idwInOutMode = 0 Then
                    dsNewRow.Item("ATN_INTIME") = idwHour.ToString() & ":" & idwMinute.ToString()
                    dsNewRow.Item("ATN_OUTTIME") = "#00:00#"
                Else
                    dsNewRow.Item("ATN_INTIME") = "#00:00#"
                    dsNewRow.Item("ATN_OUTTIME") = idwHour.ToString() & ":" & idwMinute.ToString()
                End If
                dsNewRow.Item("ATN_LATEBY") = 0
                dsNewRow.Item("ATN_EARLYBY") = 0
                dsNewRow.Item("MODIFIED_DATE") = Now.ToString("MM/dd/yyyy")
                dsNewRow.Item("CREATED_DATE") = Now.ToString("MM/dd/yyyy")
                ds.Tables(DBNAME).Rows.Add(dsNewRow)
                da.Update(ds, DBNAME)

            End While
            MsgBox(iGLCount)
        Else
            Cursor = Cursors.Default
            axCZKEM1.GetLastError(idwErrorCode)
            If idwErrorCode <> 0 Then
                MsgBox("Reading data from terminal failed,ErrorCode: " & idwErrorCode, MsgBoxStyle.Exclamation, "Error")
            Else
                MsgBox("No data from terminal returns!", MsgBoxStyle.Exclamation, "Error")
            End If
        End If

        axCZKEM1.EnableDevice(iMachineNumber, True) 'enable the device
        Cursor = Cursors.Default
    End Sub
    'Get the count of attendance records in from ternimal.
    Private Sub btnGetDeviceStatus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        If bIsConnected = False Then
            MsgBox("Please connect the device first", MsgBoxStyle.Exclamation, "Error")
            Return
        End If
        Dim idwErrorCode As Integer
        Dim iValue = 0

        axCZKEM1.EnableDevice(iMachineNumber, False) 'disable the device
        If axCZKEM1.GetDeviceStatus(iMachineNumber, 6, iValue) = True Then 'Here we use the function "GetDeviceStatus" to get the record's count.The parameter "Status" is 6.
            MsgBox("The count of the AttLogs in the device is " + iValue.ToString(), MsgBoxStyle.Information, "Success")
        Else
            axCZKEM1.GetLastError(idwErrorCode)
            MsgBox("Operation failed,ErrorCode=" & idwErrorCode, MsgBoxStyle.Exclamation, "Error")
        End If

        axCZKEM1.EnableDevice(iMachineNumber, True) 'enable the device
    End Sub
    'Clear all attendance records from terminal.
    Private Sub btnClearGLog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'If bIsConnected = False Then
        '    MsgBox("Please connect the device first", MsgBoxStyle.Exclamation, "Error")
        '    Return
        'End If
        'Dim idwErrorCode As Integer

        'lvLogs.Items.Clear()
        'AxCZKEM1.EnableDevice(iMachineNumber, False) 'disable the device
        'If AxCZKEM1.ClearGLog(iMachineNumber) = True Then
        '    AxCZKEM1.RefreshData(iMachineNumber) 'the data in the device should be refreshed
        '    MsgBox("All att Logs have been cleared from teiminal!", MsgBoxStyle.Information, "Success")
        'Else
        '    AxCZKEM1.GetLastError(idwErrorCode)
        '    MsgBox("Operation failed,ErrorCode=" & idwErrorCode, MsgBoxStyle.Exclamation, "Error")
        'End If

        'AxCZKEM1.EnableDevice(iMachineNumber, True) 'enable the device
    End Sub
#End Region

    Private Sub AttLogs_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Call db_connection_open()

        Sql = "SELECT BRN_BRANCHCODE, BRN_BRANCHNAME FROM BRANCH WHERE BRN_DELETE =0"
        da = New OleDb.OleDbDataAdapter(Sql, con)
        da.Fill(ds, DBNAME)
        clearField()

    End Sub
    Private Sub clearField()
        txtIP.Text = "192.168.1.160"
        txtPort.Text = "4370"
        cmbBranchName.Items.Clear()
        loadBranch()
    End Sub

    Private Sub loadBranch()

        'LOAD BRANCH
        Sql = "SELECT BRN_BRANCHCODE, BRN_BRANCHNAME FROM BRANCH WHERE BRN_DELETE=0"
        cusDa = New OleDb.OleDbDataAdapter(Sql, con)
        cusDa.Fill(cusDs, DBNAME)
        Dim rowCount = cusDs.Tables(DBNAME).Rows.Count
        cmbBranchName.Items.Clear()
        For i = 0 To rowCount - 1
            branchCode(i) = cusDs.Tables(DBNAME).Rows(i).Item(0)
            cmbBranchName.Items.Add(cusDs.Tables(DBNAME).Rows(i).Item(1))
        Next
    End Sub

    
End Class
